<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSelfInfoByParams(array $params)
 * @method getStreamInfoByParams(array $params)
 * @method getAllRetouchClassByParams(array $params)
 * @method getAllProductByParams(array $params)
 * @method getAllRoleByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 * @method getRetouchOrgListByParams(array $params)
 * @method getProductInfoByParams(array $params)
 * @method getAuthorityByParams(array $params)
 * @method getStaffListByParams(array $params)
 * @method getWaitRetouchStreamQueueByParams(array $params)
 * @method streamToRetoucherByParams(array $params)
 * @method streamToReviewerByParams(array $params)
 * @method delWaitRetoucherQueueByParams(array $params)
 * @method staffExitStreamByParams(array $params)
 * @method rePushStreamQueueByParams(array $params)
 * @method pushRetoucherByParams(array $params)
 * @method pushReviewerByParams(array $params)
 * @method pullRetoucherByParams(array $params)
 * @method pullReviewerByParams(array $params)
 * @method getSelfStaffsByParams(array $params)
 * @method getCloudRetoucherByParams(array $params)
 * @method getReviewerByParams(array $params)
 * @method getRetoucherGroupByParams(array $params)
 * @method getPhotographerOrgByParams(array $params)
 * @method getRetoucherOrgByParams(array $params)
 * @method getRetoucherOrgWithProductByParams(array $params)
 * @method initRandomSequenceByParams(array $params)
 * @method streamTimeRpcLogByParams(array $params)
 * @method getCacheCountByParams(array $params)
 * @method incrCacheCountByParams(array $params)
 * @method getWebSocketSignatureByParams(array $params)
 * @method webSocketByParams(array $params)
 * @method getRetoucherLeadersByParams(array $params)
 * @method getOnlineStateByParams(array $params)
 * @method wsOfflineByParams(array $params)
 * @method getPhotoProblemTagSetsByParams(array $params)
 * @method addVersionInfoByParams(array $params)
 * @method updateVersionInfoByParams(array $params)
 * @method getVersionInfoForPaginateByParams(array $params)
 * @method getAllVersionNumByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取当前个人信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSelfInfo () {
        return self::getClass()->getSelfInfo();
    }

    /**
     * 获取流水信息
     *
     * @param  int $streamId 流水id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamInfo (int $streamId) {
        return self::getClass()->getStreamInfo([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 获取全部修图类型
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllRetouchClass () {
        return self::getClass()->getAllRetouchClass();
    }

    /**
     * 获取全部产品
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllProduct () {
        return self::getClass()->getAllProduct();
    }

    /**
     * 获取全部角色组
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllRole () {
        return self::getClass()->getAllRole();
    }

    /**
     * 获取订单信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderInfo (int $orderId) {
        return self::getClass()->getOrderInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取所有修图机构
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRetouchOrgList () {
        return self::getClass()->getRetouchOrgList();
    }

    /**
     * 获取产品信息
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductInfo (int $productId) {
        return self::getClass()->getProductInfo([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取权限信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAuthority () {
        return self::getClass()->getAuthority();
    }

    /**
     * 获取伙伴列表
     *
     * @param  bool $needDelete 需要禁用的账户 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffList (bool $needDelete) {
        return self::getClass()->getStaffList([
            "needDelete" => $needDelete,
        ]);
    }

    /**
     * test获取队列
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getWaitRetouchStreamQueue () {
        return self::getClass()->getWaitRetouchStreamQueue();
    }

    /**
     * test指定修片师
     *
     * @support  int $staffId staffId [ require true ]
     * @support  int $streamId streamId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function streamToRetoucher () {
        return self::getClass()->streamToRetoucher();
    }

    /**
     * test指定审核人
     *
     * @support  int $staffId staffId [ require true ]
     * @support  int $streamId streamId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function streamToReviewer () {
        return self::getClass()->streamToReviewer();
    }

    /**
     * test清空队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function delWaitRetoucherQueue () {
        return self::getClass()->delWaitRetoucherQueue();
    }

    /**
     * 修片解绑-test-辅助
     *
     * @support  string $streamNum streamNum [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffExitStream () {
        return self::getClass()->staffExitStream();
    }

    /**
     * 重推修片&amp;审核队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function rePushStreamQueue () {
        return self::getClass()->rePushStreamQueue();
    }

    /**
     * 人员推到队列
     *
     * @support  int $staffId staffId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushRetoucher () {
        return self::getClass()->pushRetoucher();
    }

    /**
     * 人员推到审核队列
     *
     * @support  int $staffId staffId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pushReviewer () {
        return self::getClass()->pushReviewer();
    }

    /**
     * 人员推出修片队列
     *
     * @support  int $staffId staffId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pullRetoucher () {
        return self::getClass()->pullRetoucher();
    }

    /**
     * 人员推出审核队列
     *
     * @support  int $staffId staffId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pullReviewer () {
        return self::getClass()->pullReviewer();
    }

    /**
     * 获取自己所有组员
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSelfStaffs () {
        return self::getClass()->getSelfStaffs();
    }

    /**
     * 获取云端所有修图师
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCloudRetoucher () {
        return self::getClass()->getCloudRetoucher();
    }

    /**
     * 获取所有审核人
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getReviewer () {
        return self::getClass()->getReviewer();
    }

    /**
     * 获取所有修图组
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherGroup () {
        return self::getClass()->getRetoucherGroup();
    }

    /**
     * 获取摄影机构
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotographerOrg () {
        return self::getClass()->getPhotographerOrg();
    }

    /**
     * 获取修片机构
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherOrg () {
        return self::getClass()->getRetoucherOrg();
    }

    /**
     * 获取修片机构及可接产品
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherOrgWithProduct () {
        return self::getClass()->getRetoucherOrgWithProduct();
    }

    /**
     * test初始化当日随机数
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function initRandomSequence () {
        return self::getClass()->initRandomSequence();
    }

    /**
     * 记录流水时间点
     *
     * @support  int $streamId 流水id [Original type uint] [ require true ]
     * @support  string $event 事件名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function streamTimeRpcLog () {
        return self::getClass()->streamTimeRpcLog();
    }

    /**
     * 获取缓存
     *
     * @param  string $cacheKey 缓存key [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCacheCount (string $cacheKey) {
        return self::getClass()->getCacheCount([
            "cacheKey" => $cacheKey,
        ]);
    }

    /**
     * 递增缓存
     *
     * @param  string $cacheKey 缓存key [ require true ]
     * @param  int $increment 递增/递减值 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function incrCacheCount (string $cacheKey, int $increment = 1) {
        return self::getClass()->incrCacheCount([
            "cacheKey" => $cacheKey,
            "increment" => $increment,
        ]);
    }

    /**
     * 获取ws票据
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getWebSocketSignature () {
        return self::getClass()->getWebSocketSignature();
    }

    /**
     * webSocket入口
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function webSocket () {
        return self::getClass()->webSocket();
    }

    /**
     * 获取修片主管和运营主管
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherLeaders () {
        return self::getClass()->getRetoucherLeaders();
    }

    /**
     * 获取全局在线状态
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOnlineState () {
        return self::getClass()->getOnlineState();
    }

    /**
     * wsOffline
     *
     * @param  int $staffId staffId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function wsOffline (int $staffId) {
        return self::getClass()->wsOffline([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取摄影化妆问题标签
     *
     * @param  string $about photography/makeup [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoProblemTagSets (string $about = NULL) {
        return self::getClass()->getPhotoProblemTagSets([
            "about" => $about,
        ]);
    }

    /**
     * 添加版本更新信息
     *
     * @support  string $versionNum 版本号 [ require true ]
     * @support  string $info 版本更新信息 [ require true ]
     * @support  string $versionTime 版本时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addVersionInfo () {
        return self::getClass()->addVersionInfo();
    }

    /**
     * 修改版本更新信息
     *
     * @param  int $id id [ require true ]
     * @support  string $versionNum 版本号 
     * @support  string $info 版本更新信息 
     * @support  string $versionTime 版本时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateVersionInfo (int $id) {
        return self::getClass()->updateVersionInfo([
            "id" => $id,
        ]);
    }

    /**
     * 获取版本更新信息分页
     *
     * @param  string $versionNum 版本号 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 页数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getVersionInfoForPaginate (string $versionNum = '', int $page = 0, int $pageSize = 10) {
        return self::getClass()->getVersionInfoForPaginate([
            "versionNum" => $versionNum,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 过去所有版本号
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllVersionNum () {
        return self::getClass()->getAllVersionNum();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}