<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffListByPageByParams(array $params)
 * @method getStaffInfoByParams(array $params)
 * @method searchStaffInfoByParams(array $params)
 * @method getStaffPermissionByParams(array $params)
 * @method addStaffByParams(array $params)
 * @method editStaffByParams(array $params)
 * @method enableStaffByParams(array $params)
 * @method disableStaffByParams(array $params)
 * @method addRetoucherClassByParams(array $params)
 * @method editRetoucherClassByParams(array $params)
 * @method delRetoucherClassByParams(array $params)
 * @method getLevelListByParams(array $params)
 * @method getAllLevelExpByParams(array $params)
 * @method getIdentityListByParams(array $params)
 * @method getRetoucherClassInfoByParams(array $params)
 * @method getRetoucherClassListByParams(array $params)
 * @method addRoleByParams(array $params)
 * @method editRoleByParams(array $params)
 * @method delRoleByParams(array $params)
 * @method getRoleInfoByParams(array $params)
 * @method getRoleListByParams(array $params)
 * @method getPermissionListByParams(array $params)
 * @method getCanScoreStaffsByParams(array $params)
 * @method batchSaveStaffScoresByParams(array $params)
 * @method editStaffScoreByParams(array $params)
 * @method getStaffScoresByParams(array $params)
 * @method getGroupScoreRanksByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取账号列表
     *
     * @param  string $staffName 伙伴姓名/花名 [ require true ]
     * @param  int $roleId 角色id [Original type uint] [ require true ]
     * @param  int $page 分页 [ require true ]
     * @param  int $pageSize 每页大小 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffListByPage (string $staffName = '', int $roleId = 0, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStaffListByPage([
            "staffName" => $staffName,
            "roleId" => $roleId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取伙伴信息
     *
     * @param  int $staffNum 伙伴工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffInfo (int $staffNum) {
        return self::getClass()->getStaffInfo([
            "staffNum" => $staffNum,
        ]);
    }

    /**
     * 查询伙伴信息
     *
     * @param  int $staffNum 伙伴工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchStaffInfo (int $staffNum) {
        return self::getClass()->searchStaffInfo([
            "staffNum" => $staffNum,
        ]);
    }

    /**
     * 查询伙伴权限信息
     *
     * @param  int $staffNum 伙伴工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffPermission (int $staffNum) {
        return self::getClass()->getStaffPermission([
            "staffNum" => $staffNum,
        ]);
    }

    /**
     * 添加伙伴 ----2.6更新
     *
     * @support  array $productIds 可接产品ids 
     * @support  int $retoucherClass 修图师类别 [Original type uint] [ require true ]
     * @support  int $roleId 角色组 [Original type uint] [ require true ]
     * @support  array $permissionIds 权限ids [ require true ]
     * @support  int $level 等级 [ require true ]
     * @support  float $exp 海草 [Original type double] [ require true ]
     * @support  string $identity 修图身份 [ require true ]
     * @support  int $staffNum 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStaff () {
        return self::getClass()->addStaff();
    }

    /**
     * 编辑伙伴 ----2.6更新
     *
     * @support  int $staffNum 工号 [Original type uint] [ require true ]
     * @support  array $productIds 可接产品ids 
     * @support  int $retoucherClass 修图师类别 [Original type uint] [ require true ]
     * @support  int $roleId 角色组 [Original type uint] [ require true ]
     * @support  int $level 等级 [ require true ]
     * @support  float $exp 海草 [Original type double] [ require true ]
     * @support  string $identity 修图身份 [ require true ]
     * @support  array $permissionIds 权限ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editStaff () {
        return self::getClass()->editStaff();
    }

    /**
     * 启用伙伴
     *
     * @param  int $staffId staffId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableStaff (int $staffId) {
        return self::getClass()->enableStaff([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 禁用伙伴
     *
     * @param  int $staffId staffId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableStaff (int $staffId) {
        return self::getClass()->disableStaff([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 添加修片师类别
     *
     * @param  string $name 名称 [ require true ]
     * @param  array $productIds 可接产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addRetoucherClass (string $name, array $productIds) {
        return self::getClass()->addRetoucherClass([
            "name" => $name,
            "productIds" => $productIds,
        ]);
    }

    /**
     * 编辑修片师类别
     *
     * @param  int $retoucherClassId id [Original type uint] [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  array $productIds 可接产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRetoucherClass (string $name, array $productIds, int $retoucherClassId) {
        return self::getClass()->editRetoucherClass([
            "name" => $name,
            "productIds" => $productIds,
            "retoucherClassId" => $retoucherClassId,
        ]);
    }

    /**
     * 删除修片师类别
     *
     * @param  int $retoucherClassId id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delRetoucherClass (int $retoucherClassId) {
        return self::getClass()->delRetoucherClass([
            "retoucherClassId" => $retoucherClassId,
        ]);
    }

    /**
     * 获取等级列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLevelList () {
        return self::getClass()->getLevelList();
    }

    /**
     * 获取各等级升级经验值
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllLevelExp () {
        return self::getClass()->getAllLevelExp();
    }

    /**
     * 获取修图身份列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdentityList () {
        return self::getClass()->getIdentityList();
    }

    /**
     * 获取修片师类别
     *
     * @param  int $retoucherClassId 修片师类别id [Original type uint] [ require true ]
     * @param  bool $additionInfo 附加信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetoucherClassInfo (int $retoucherClassId, bool $additionInfo = false) {
        return self::getClass()->getRetoucherClassInfo([
            "retoucherClassId" => $retoucherClassId,
            "additionInfo" => $additionInfo,
        ]);
    }

    /**
     * 获取修片师类别列表
     *
     * @param  int $retouchClassId 修图类别id [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherClassList (int $retouchClassId = 0, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getRetoucherClassList([
            "retouchClassId" => $retouchClassId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 添加角色
     *
     * @support  string $title 角色组名称 [ require true ]
     * @support  array $permissionIds 权限数组 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addRole () {
        return self::getClass()->addRole();
    }

    /**
     * 编辑角色权限
     *
     * @support  int $roleId 角色组id [ require true ]
     * @support  array $permissionIds 权限数组 [ require true ]
     * @support  string $title 标题 
     * @support  string $desc 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRole () {
        return self::getClass()->editRole();
    }

    /**
     * 删除角色
     *
     * @param  int $roleId 角色组id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delRole (int $roleId) {
        return self::getClass()->delRole([
            "roleId" => $roleId,
        ]);
    }

    /**
     * 获取角色信息
     *
     * @param  int $roleId 角色组id [Original type uint] [ require true ]
     * @param  bool $additionInfo 额外信息，是否有作用的伙伴 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRoleInfo (int $roleId, bool $additionInfo = false) {
        return self::getClass()->getRoleInfo([
            "roleId" => $roleId,
            "additionInfo" => $additionInfo,
        ]);
    }

    /**
     * 获取角色列表
     *
     * @support  string $title 搜索角色名字 
     * @support  int $page 分页 
     * @support  int $pageSize 每页大小 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRoleList () {
        return self::getClass()->getRoleList();
    }

    /**
     * 获取所有权限列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPermissionList () {
        return self::getClass()->getPermissionList();
    }

    /**
     * 获取可打分伙伴s
     *
     * @support  string $type 该次评分的针对对象 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCanScoreStaffs () {
        return self::getClass()->getCanScoreStaffs();
    }

    /**
     * 批量保存staff打分信息
     *
     * @support  array $staffScores staffScores [ require true ]
     * @support  string $type 该次评分的针对对象 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSaveStaffScores () {
        return self::getClass()->batchSaveStaffScores();
    }

    /**
     * 编辑staff分数
     *
     * @support  int $id 记录id [Original type uint] [ require true ]
     * @support  float $score 新分数 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editStaffScore () {
        return self::getClass()->editStaffScore();
    }

    /**
     * 获取Staff分数列表
     *
     * @support  string $cycle 周期 [ require true ]
     * @support  array $staffIds 伙伴id 
     * @support  string $type 该次评分的针对对象 [ require true ]
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffScores (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getStaffScores([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取组排名分数数据
     *
     * @support  string $cycle 周期 
     * @param  string $type 该次评分的针对对象 [ require true ]
     * @support  int $groupId 组ID [Original type uint] 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @support  string $cycleFormat 周期 [ require true ]
     * @support  string $startAt 开始时间 
     * @support  string $endAt 结束时间 
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupScoreRanks (string $type, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getGroupScoreRanks([
            "type" => $type,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}