<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method submitFinalFilmByParams(array $params)
 * @method clearFinishPhotoByParams(array $params)
 * @method batchGetPhotoInfoByIdByParams(array $params)
 * @method batchGetPhotoInfoByIdsByParams(array $params)
 * @method firstPhotoInfoByIdByParams(array $params)
 * @method batchPhotosAndPagesByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 提交最终成片[看片完成]
     *
     * @param  array $versionData 成片信息 [ require true ]
     * @param  string $streamNum 流水号 [ require true ]
     * @support  bool $part 是否开启部分提交 
     * @throws  \Exception
     * @return  string
     */
    public static function submitFinalFilm (array $versionData, string $streamNum) {
        return self::getClass()->submitFinalFilm([
            "versionData" => $versionData,
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 清空流水－顾客满意片
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function clearFinishPhoto (string $streamNum) {
        return self::getClass()->clearFinishPhoto([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 根据照片id批量获取照片信息
     *
     * @param  array $ids 照片id [ require true ]
     * @param  string $position 版本位置 [ require true ]
     * @param  string $version 版本名称 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function batchGetPhotoInfoById (array $ids, string $position, string $version = NULL) {
        return self::getClass()->batchGetPhotoInfoById([
            "ids" => $ids,
            "position" => $position,
            "version" => $version,
        ]);
    }

    /**
     * 根据照片id批量获取照片信息-包含订单信息
     *
     * @param  array $ids 照片id [ require true ]
     * @param  array $versions 版本名称s [ require true ]
     * @param  string $extend 包含数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetPhotoInfoByIds (array $ids, array $versions, string $extend = 'cloud_spot_check') {
        return self::getClass()->batchGetPhotoInfoByIds([
            "ids" => $ids,
            "versions" => $versions,
            "extend" => $extend,
        ]);
    }

    /**
     * 根据id获取照片信息
     *
     * @param  int $id 照片id [ require true ]
     * @param  string $position 获取当前版本的第一个或者最后一个 [ require true ]
     * @param  string $version 照片版本 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function firstPhotoInfoById (int $id, string $position, string $version = NULL) {
        return self::getClass()->firstPhotoInfoById([
            "id" => $id,
            "position" => $position,
            "version" => $version,
        ]);
    }

    /**
     * 批量获取订单照片信息-支持分页
     *
     * @support  array $externalNums 外部订单号s [ require true ]
     * @support  array $photoIds 照片ids 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchPhotosAndPages (int $page, int $pageSize) {
        return self::getClass()->batchPhotosAndPages([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}