<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method takeItemByParams(array $params)
 * @method getHaveSpotCheckResultByParams(array $params)
 * @method getSpotCheckResultByParams(array $params)
 * @method getSearchHistoryByParams(array $params)
 * @method getStatisticsByParams(array $params)
 * @method commitHistoryByParams(array $params)
 * @method fixCheckPoolConfigByParams(array $params)
 * @method addScoreConfigByParams(array $params)
 * @method editScoreConfigByParams(array $params)
 * @method editChildScoreConfigByParams(array $params)
 * @method delScoreConfigByParams(array $params)
 * @method getScoreConfigListByParams(array $params)
 * @method setWeightsScoreByParams(array $params)
 * @method getWeightsScoreByParams(array $params)
 */
class CheckPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 云学院抽片
     *
     * @support  int $takeNum 抽取数量 [ require true ]
     * @support  string $passStartAt 审核通过开始时间 [ require true ]
     * @support  string $passEndAt 审核通过结束时间 [ require true ]
     * @support  string $retouchStandard 修片标准 
     * @throws  \Exception
     * @return  string
     */
    public static function takeItem () {
        return self::getClass()->takeItem();
    }

    /**
     * 获取是否有未评分的抽片
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getHaveSpotCheckResult () {
        return self::getClass()->getHaveSpotCheckResult();
    }

    /**
     * 获取抽片结果
     *
     * @param  string $uuid 抽查配置UUID [ require true ]
     * @param  int $skip 跳过数量 [Original type uint] [ require true ]
     * @param  int $limit 获取数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSpotCheckResult (string $uuid, int $skip = 0, int $limit = 10) {
        return self::getClass()->getSpotCheckResult([
            "uuid" => $uuid,
            "skip" => $skip,
            "limit" => $limit,
        ]);
    }

    /**
     * 获取抽片历史记录
     *
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  array $retoucherIds 修图师id 
     * @support  array $tagIds 问题标签 
     * @param  int $page 页数 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSearchHistory (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getSearchHistory([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取今日抽片指标
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStatistics () {
        return self::getClass()->getStatistics();
    }

    /**
     * 云学院提交评价
     *
     * @param  int $photoId 照片id [ require true ]
     * @param  string $uuid uuid [ require true ]
     * @param  array $tags 标签id [ require true ]
     * @param  string $picUrl 照片地址 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function commitHistory (string $uuid, int $photoId, string $picUrl = '', array $tags = []) {
        return self::getClass()->commitHistory([
            "uuid" => $uuid,
            "photoId" => $photoId,
            "picUrl" => $picUrl,
            "tags" => $tags,
        ]);
    }

    /**
     * 抽片池配置修改-test
     *
     * @param  array $configData 配置data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixCheckPoolConfig (array $configData) {
        return self::getClass()->fixCheckPoolConfig([
            "configData" => $configData,
        ]);
    }

    /**
     * 添加云学院评分配置
     *
     * @param  string $mainName 大类名称 [ require true ]
     * @param  array $configData 配置data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addScoreConfig (string $mainName, array $configData) {
        return self::getClass()->addScoreConfig([
            "mainName" => $mainName,
            "configData" => $configData,
        ]);
    }

    /**
     * 修改云学院评分配置
     *
     * @param  int $id 大类id [ require true ]
     * @param  string $mainName 大类名称 [ require true ]
     * @param  array $configData 配置data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editScoreConfig (int $id, string $mainName, array $configData) {
        return self::getClass()->editScoreConfig([
            "id" => $id,
            "mainName" => $mainName,
            "configData" => $configData,
        ]);
    }

    /**
     * 修改云学院细类评分配置
     *
     * @param  int $id 细类id [ require true ]
     * @param  array $configData 配置data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editChildScoreConfig (int $id, array $configData) {
        return self::getClass()->editChildScoreConfig([
            "id" => $id,
            "configData" => $configData,
        ]);
    }

    /**
     * 删除云学院评分配置
     *
     * @param  int $id 细类id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delScoreConfig (int $id) {
        return self::getClass()->delScoreConfig([
            "id" => $id,
        ]);
    }

    /**
     * 获取云学院评分配置
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getScoreConfigList () {
        return self::getClass()->getScoreConfigList();
    }

    /**
     * 设置权重
     *
     * @param  int $score 细类id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setWeightsScore (int $score) {
        return self::getClass()->setWeightsScore([
            "score" => $score,
        ]);
    }

    /**
     * 获取权重
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWeightsScore () {
        return self::getClass()->getWeightsScore();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'CheckPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'CheckPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}