<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUpyunSignByParams(array $params)
 * @method getHostByParams(array $params)
 * @method addWatcherNameByParams(array $params)
 * @method getStoreReturnReasonsByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 公用获取又拍云签名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUpyunSign () {
        return self::getClass()->getUpyunSign();
    }

    /**
     * 公用返回host
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 修改流水看片师
     *
     * @param  string $watcherName 看片师姓名 [ require true ]
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function addWatcherName (string $watcherName, string $streamNum) {
        return self::getClass()->addWatcherName([
            "watcherName" => $watcherName,
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 获取所有门店退回原因
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreReturnReasons () {
        return self::getClass()->getStoreReturnReasons();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}