<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTodayQuotaByParams(array $params)
 * @method getGroupStaffTodayQuotaListByParams(array $params)
 * @method changeGroupStaffWorkLoadByParams(array $params)
 * @method getGroupStaffQuotaInfoByParams(array $params)
 * @method getStaffQuotaInfoGroupByStaffByParams(array $params)
 * @method getGroupStaffQuotaForCloudSchoolInfoByParams(array $params)
 * @method getGroupStaffQuotaForCloudSchoolInfoByStaffByParams(array $params)
 * @method getGroupStaffScoreForCloudSchoolInfoByStaffByParams(array $params)
 * @method getStaffRetouchListByParams(array $params)
 */
class RetouchLeader {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取今日指标[整组]
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getTodayQuota () {
        return self::getClass()->getTodayQuota();
    }

    /**
     * 获取组员今日指标列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupStaffTodayQuotaList () {
        return self::getClass()->getGroupStaffTodayQuotaList();
    }

    /**
     * 延后做
     *
     * @support  int $staffId 伙伴id [Original type uint] [ require true ]
     * @support  int $expect 预计工作量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeGroupStaffWorkLoad () {
        return self::getClass()->changeGroupStaffWorkLoad();
    }

    /**
     * 获取组员修图报告【可查询全部】
     *
     * @support  int $staffId 伙伴id [Original type uint] 
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupStaffQuotaInfo () {
        return self::getClass()->getGroupStaffQuotaInfo();
    }

    /**
     * 获取所有组员修图报告[分组]
     *
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffQuotaInfoGroupByStaff () {
        return self::getClass()->getStaffQuotaInfoGroupByStaff();
    }

    /**
     * 获取所有组员云学院修图报告统计
     *
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @param  array $staffIds ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupStaffQuotaForCloudSchoolInfo (array $staffIds = []) {
        return self::getClass()->getGroupStaffQuotaForCloudSchoolInfo([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 获取所有组员云学院修图报告(柱状图) -----2.4
     *
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @param  array $staffIds ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupStaffQuotaForCloudSchoolInfoByStaff (array $staffIds = []) {
        return self::getClass()->getGroupStaffQuotaForCloudSchoolInfoByStaff([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 获取所有组员云学院修图评分(条状图) -----2.4
     *
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @param  array $staffIds ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupStaffScoreForCloudSchoolInfoByStaff (array $staffIds = []) {
        return self::getClass()->getGroupStaffScoreForCloudSchoolInfoByStaff([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * 获取组员修图记录
     *
     * @support  int $staffId 伙伴id [Original type uint] 
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  bool $isStoreReturn 是否门店退后 
     * @support  bool $isCloudEvaluation 是否被抽片打分 
     * @support  bool $isLichma 是否是利奇马 
     * @support  string $storeEvaluate 门店评价 
     * @support  array $tagIds 问题标签id 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffRetouchList (int $page, int $pageSize) {
        return self::getClass()->getStaffRetouchList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'RetouchLeader');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'RetouchLeader');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}