<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method manualUpgradeStaffLevelByParams(array $params)
 * @method fixStaffIncomeByParams(array $params)
 * @method getQueueLengthByParams(array $params)
 */
class Temple {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 手动升级
     *
     * @param  int $staffId 工号 [ require true ]
     * @param  array $staffData 员工信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function manualUpgradeStaffLevel (int $staffId, array $staffData) {
        return self::getClass()->manualUpgradeStaffLevel([
            "staffId" => $staffId,
            "staffData" => $staffData,
        ]);
    }

    /**
     * 修复伙伴收益
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  int $staffId 员工工号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixStaffIncome (string $startAt, string $endAt, int $staffId = NULL) {
        return self::getClass()->fixStaffIncome([
            "startAt" => $startAt,
            "endAt" => $endAt,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 【大数据使用】
     *
     * @param  string $queueName 队列名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQueueLength (string $queueName) {
        return self::getClass()->getQueueLength([
            "queueName" => $queueName,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Temple');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Temple');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}