<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-23 15:39:41
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Stream
 * @method createStreamByParams(array $params) 创建流水
 * @method createStreamWithServantByParams(array $params) 创建流水-v2.3.8 -- 支持试修服务
 * @method getStreamInfoByParams(array $params) 获取流水单详情
 * @method batchGetStreamInfoByParams(array $params) 批量获取流水单信息
 * @method revokeStreamByParams(array $params) 撤回流水单[接单后的1分钟内]
 * @method evaluateStreamByParams(array $params) 门店评价流水
 * @method storeReturnStreamByParams(array $params) 门店退回流水照片
 * @method getStreamIdQueueByParams(array $params) 门店获取流水队列
 * @method editRetouchClaimByParams(array $params) 修改订单修图要求
 * @method urgentStreamByNumWithTypeByParams(array $params) api加急流水
 * @method streamAbandonByParams(array $params) streamAbandon
 * @method batchReturnStreamByParams(array $params) 批量退回
 * @method getStreamByRetoucherIdByParams(array $params) 获取修图师某时间内接单信息
 * @method getStoreEvaluateStreamByParams(array $params) 获取门店评价修图师
 * @method evaluateStreamV2ByParams(array $params) 门店评价流水
 * @method reworkStreamIsEvaluateByStreamNumsByParams(array $params) 批量查询退回流水是否已评价
 */
class Stream {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Api\\Stream";

    /**
     * 创建流水
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function createStream (string $orderNum, int $productId, array $photoData, string $retouchNote, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStream(array_merge($_params, ["orderNum" => $orderNum, "productId" => $productId, "photoData" => $photoData, "retouchNote" => $retouchNote]));
    }
    /**
     * 创建流水-v2.3.8 -- 支持试修服务
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function createStreamWithServant (string $orderNum, int $productId, array $photoData, string $retouchNote, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStreamWithServant(array_merge($_params, ["orderNum" => $orderNum, "productId" => $productId, "photoData" => $photoData, "retouchNote" => $retouchNote]));
    }
    /**
     * 获取流水单详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStreamInfo (string $streamNum, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamInfo(array_merge($_params, ["streamNum" => $streamNum]));
    }
    /**
     * 批量获取流水单信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function batchGetStreamInfo (array $streamNums, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchGetStreamInfo(array_merge($_params, ["streamNums" => $streamNums]));
    }
    /**
     * 撤回流水单[接单后的1分钟内]
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function revokeStream (string $streamNum, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->revokeStream(array_merge($_params, ["streamNum" => $streamNum]));
    }
    /**
     * 门店评价流水
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function evaluateStream (string $streamNum, string $watcherName, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->evaluateStream(array_merge($_params, ["streamNum" => $streamNum, "watcherName" => $watcherName]));
    }
    /**
     * 门店退回流水照片
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function storeReturnStream (\Mainto\Bridge\Structs\ProjectCloud\Objects\Api\Stream\StoreReturnStream $storeReturnStream) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->storeReturnStream($storeReturnStream),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\StreamApi\StoreReturnStreamDTO[]"
        );
    }
    /**
     * 门店获取流水队列
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStreamIdQueue (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamIdQueue(array_merge($_params, []));
    }
    /**
     * 修改订单修图要求
     * @return  mixed
    */
    public static function editRetouchClaim (string $streamNum, \Mainto\Bridge\Structs\ProjectCloud\Api\Stream\EditRetouchClaimParamsRetouchClaim $retouchClaim) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editRetouchClaim(["streamNum" => $streamNum, "retouchClaim" => $retouchClaim]);
    }
    /**
     * api加急流水
     * @return  mixed
    */
    public static function urgentStreamByNumWithType (string $streamNum, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->urgentStreamByNumWithType(["streamNum" => $streamNum, "type" => $type]);
    }
    /**
     * streamAbandon
     * @return  bool
    */
    public static function streamAbandon (array $streamNums, int $photographerOrgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->streamAbandon(["streamNums" => $streamNums, "photographerOrgId" => $photographerOrgId]);
    }
    /**
     * 批量退回
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function batchReturnStream (\Mainto\Bridge\Structs\ProjectCloud\Objects\Api\Stream\BatchStoreReturnStream $batchStoreReturnStream) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchReturnStream($batchStoreReturnStream);
    }
    /**
     * 获取修图师某时间内接单信息
     * @return  array
    */
    public static function getStreamByRetoucherId (\Mainto\Bridge\Structs\ProjectCloud\CMD\GetStreamByRetoucherIdCMD $getStreamByRetoucherIdCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStreamByRetoucherId($getStreamByRetoucherIdCMD),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\GetStreamByRetoucherIdDTO[]"
        );
    }
    /**
     * 获取门店评价修图师
     * @return  string
    */
    public static function getStoreEvaluateStream (\Mainto\Bridge\Structs\ProjectCloud\Objects\Stream\GetStoreEvaluateStream $getStoreEvaluateStream) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreEvaluateStream($getStoreEvaluateStream);
    }
    /**
     * 门店评价流水
     * @return  bool
    */
    public static function evaluateStreamV2 (\Mainto\Bridge\Structs\ProjectCloud\Objects\Api\Stream\EvaluateStreamV2 $evaluateStreamV2) {
        return RpcClass::getClass(self::$serviceName, self::$className)->evaluateStreamV2($evaluateStreamV2);
    }
    /**
     * 批量查询退回流水是否已评价
     * @return  array
    */
    public static function reworkStreamIsEvaluateByStreamNums (\Mainto\Bridge\Structs\ProjectCloud\Objects\Api\Stream\ReworkStreamIsEvaluateByStreamNums $reworkStreamIsEvaluateByStreamNums) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->reworkStreamIsEvaluateByStreamNums($reworkStreamIsEvaluateByStreamNums),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\StreamApi\ReworkStreamIsEvaluateByStreamNumsDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}