<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-11 16:34:15
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class RetouchLeader
 * @method getTodayQuotaByParams(array $params) 获取今日指标[整组]
 * @method getGroupStaffTodayQuotaListByParams(array $params) 获取组员今日指标列表
 * @method getStaffQuotaInfoGroupByStaffByParams(array $params) 获取所有组员修图报告[分组]
 * @method getGroupStaffQuotaForCloudSchoolInfoByParams(array $params) 获取所有组员云学院修图报告统计
 * @method getGroupStaffQuotaForCloudSchoolInfoByStaffByParams(array $params) 获取所有组员云学院修图报告(柱状图) -----2.4
 * @method getGroupStaffScoreForCloudSchoolInfoByStaffByParams(array $params) 获取所有组员云学院修图评分(条状图) -----2.4
 * @method getReworkQuotaGroupByStaffByParams(array $params) 获取所有组员退单报告(条状图) -----2.10
 * @method getStaffRetouchListByParams(array $params) 获取组员修图记录
 * @method getStoreReturnQuotaByParams(array $params) 退单报告模块&lt;兼容云端组织架构调整&gt;
 * @method getCheckPoolQuotaByParams(array $params) 获取组员云学院报告绩效&lt;2.10更新接口&gt;
 * @method getCheckPoolSubQuotaByParams(array $params) 获取组员云学院报告绩效&lt;2.10更新接口&gt;
 * @method getCloudProblemReportByGroupByParams(array $params) 获取云学院问题统计(柱状图) ---2.10更新
 * @method getLittleBeeInfoByParams(array $params) [主管]获取小蜜蜂奖励信息－2.8
 * @method getCloudScoreByGroupByParams(array $params) 获取云学院修图组分数统计(柱状图) ---2.24更新
 * @method getCloudProblemByGroupByParams(array $params) 获取云学院修图组分数统计(柱状图) ---2.24更新
 * @method getShowPicScoreByGroupByParams(array $params) 获取修修兽修图组分数统计(柱状图) ---2.24更新
 * @method getShowPicProblemByGroupByParams(array $params) 获取修修兽修图组分数统计(柱状图) ---2.24更新
 */
class RetouchLeader {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "RetouchLeader";

    /**
     * 获取今日指标[整组]
     * @return  array
    */
    public static function getTodayQuota () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTodayQuota();
    }
    /**
     * 获取组员今日指标列表
     * @return  array
    */
    public static function getGroupStaffTodayQuotaList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupStaffTodayQuotaList();
    }
    /**
     * 获取所有组员修图报告[分组]
     * @return  array
    */
    public static function getStaffQuotaInfoGroupByStaff (int $groupId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffQuotaInfoGroupByStaff(["groupId" => $groupId]);
    }
    /**
     * 获取所有组员云学院修图报告统计
     * @return  mixed
    */
    public static function getGroupStaffQuotaForCloudSchoolInfo (int $groupId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupStaffQuotaForCloudSchoolInfo(["groupId" => $groupId]);
    }
    /**
     * 获取所有组员云学院修图报告(柱状图) -----2.4
     * @return  mixed
    */
    public static function getGroupStaffQuotaForCloudSchoolInfoByStaff () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupStaffQuotaForCloudSchoolInfoByStaff([]);
    }
    /**
     * 获取所有组员云学院修图评分(条状图) -----2.4
     * @return  mixed
    */
    public static function getGroupStaffScoreForCloudSchoolInfoByStaff () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupStaffScoreForCloudSchoolInfoByStaff([]);
    }
    /**
     * 获取所有组员退单报告(条状图) -----2.10
     * @return  mixed
    */
    public static function getReworkQuotaGroupByStaff (string $startAt, string $endAt, int $groupId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReworkQuotaGroupByStaff(["startAt" => $startAt, "endAt" => $endAt, "groupId" => $groupId]);
    }
    /**
     * 获取组员修图记录
     * @return  mixed
    */
    public static function getStaffRetouchList (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffRetouchList(["page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 退单报告模块&lt;兼容云端组织架构调整&gt;
     * @return  mixed
    */
    public static function getStoreReturnQuota (string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreReturnQuota(["startAt" => $startAt, "endAt" => $endAt]);
    }
    /**
     * 获取组员云学院报告绩效&lt;2.10更新接口&gt;
     * @return  mixed
    */
    public static function getCheckPoolQuota (string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCheckPoolQuota(["startAt" => $startAt, "endAt" => $endAt]);
    }
    /**
     * 获取组员云学院报告绩效&lt;2.10更新接口&gt;
     * @return  mixed
    */
    public static function getCheckPoolSubQuota (string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCheckPoolSubQuota(["startAt" => $startAt, "endAt" => $endAt]);
    }
    /**
     * 获取云学院问题统计(柱状图) ---2.10更新
     * @return  array
    */
    public static function getCloudProblemReportByGroup (string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudProblemReportByGroup(["startAt" => $startAt, "endAt" => $endAt]);
    }
    /**
     * [主管]获取小蜜蜂奖励信息－2.8
     * @return  mixed
    */
    public static function getLittleBeeInfo (int $year) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLittleBeeInfo(["year" => $year]);
    }
    /**
     * 获取云学院修图组分数统计(柱状图) ---2.24更新
     * @return  array
    */
    public static function getCloudScoreByGroup (string $startAt, string $endAt, int $groupId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudScoreByGroup(["startAt" => $startAt, "endAt" => $endAt, "groupId" => $groupId]);
    }
    /**
     * 获取云学院修图组分数统计(柱状图) ---2.24更新
     * @return  mixed
    */
    public static function getCloudProblemByGroup (string $startAt, string $endAt, int $groupId, int $scoreTypeId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudProblemByGroup(["startAt" => $startAt, "endAt" => $endAt, "groupId" => $groupId, "scoreTypeId" => $scoreTypeId]);
    }
    /**
     * 获取修修兽修图组分数统计(柱状图) ---2.24更新
     * @return  array
    */
    public static function getShowPicScoreByGroup (string $startAt, string $endAt, int $groupId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShowPicScoreByGroup(["startAt" => $startAt, "endAt" => $endAt, "groupId" => $groupId]);
    }
    /**
     * 获取修修兽修图组分数统计(柱状图) ---2.24更新
     * @return  array
    */
    public static function getShowPicProblemByGroup (string $startAt, string $endAt, int $groupId, int $scoreTypeId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShowPicProblemByGroup(["startAt" => $startAt, "endAt" => $endAt, "groupId" => $groupId, "scoreTypeId" => $scoreTypeId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}