<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-16 15:17:57
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\Trainning;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class StaffTrain
 * @method getHistoryListByParams(array $params) 培训历史记录
 * @method getLearnPlanListByParams(array $params) 我的计划列表
 * @method getLearningListByParams(array $params) 我的学习列表
 * @method getLearningPlanDetailByParams(array $params) 学习计划详情
 * @method getStaffLearnPlanCountByParams(array $params) 课程面板-获取个人学习计划数量
 */
class StaffTrain {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Trainning\\StaffTrain";

    /**
     * 培训历史记录
     * @return  array
    */
    public static function getHistoryList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHistoryList([]);
    }
    /**
     * 我的计划列表
     * @return  array
    */
    public static function getLearnPlanList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLearnPlanList([]);
    }
    /**
     * 我的学习列表
     * @return  array
    */
    public static function getLearningList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLearningList([]);
    }
    /**
     * 学习计划详情
     * @return  array
    */
    public static function getLearningPlanDetail (int $learningPlanId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLearningPlanDetail(["learningPlanId" => $learningPlanId]);
    }
    /**
     * 课程面板-获取个人学习计划数量
     * @return  array
    */
    public static function getStaffLearnPlanCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffLearnPlanCount();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}