<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-12-05 11:55:50
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Retoucher
 */
class Retoucher {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Api\\Retoucher";

    /**
     * 提交已修流水
     * @return  mixed
    */
    public static function submitStream (string $streamNum, array $photoData) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitStream(["streamNum" => $streamNum, "photoData" => $photoData]);
    }
    /**
     * 进入队列
     * @return  mixed
    */
    public static function joinQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->joinQueue();
    }
    /**
     * 退出队列
     * @return  mixed
    */
    public static function exitQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exitQueue();
    }
    /**
     * 主动接单
     * @return  mixed
    */
    public static function receiptStream () {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiptStream();
    }
    /**
     * 流水打标签【作为认领的标记】
     * @return  mixed
    */
    public static function tagStream (string $streamNum, string $retoucherName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->tagStream(["streamNum" => $streamNum, "retoucherName" => $retoucherName]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}