<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-24 16:07:18
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class RegionMentor
 */
class RegionMentor {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "RegionMentor";

    /**
     * 区域导师列表
     * @return  mixed
    */
    public static function getRegionMentors () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRegionMentors();
    }
    /**
     * 添加区域导师
     * @return  int
    */
    public static function addRegionMentor (string $regionName, int $mentorId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addRegionMentor(["regionName" => $regionName, "mentorId" => $mentorId]);
    }
    /**
     * 修改区域导师
     * @return  int
    */
    public static function editRegionMentor (int $id, string $regionName, int $mentorId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editRegionMentor(["id" => $id, "regionName" => $regionName, "mentorId" => $mentorId]);
    }
    /**
     * 删除区域导师
     * @return  bool
    */
    public static function delRegionMentor (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delRegionMentor(["id" => $id]);
    }
    /**
     * 添加区域修图组
     * @return  array
    */
    public static function addRegionRetouchGroup (int $regionMentorId, array $retouchGroupIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addRegionRetouchGroup(["regionMentorId" => $regionMentorId, "retouchGroupIds" => $retouchGroupIds]);
    }
    /**
     * 删除区域修图组
     * @return  bool
    */
    public static function delRegionRetouchGroup (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delRegionRetouchGroup(["id" => $id]);
    }
    /**
     * 获取未被绑定的修图组
     * @return  mixed
    */
    public static function getRetouchGroupWithNotBind () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchGroupWithNotBind();
    }
    /**
     * 获取未被绑定的导师
     * @return  mixed
    */
    public static function getMentorWithNotBind () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMentorWithNotBind();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}