<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-24 16:07:18
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Photo
 */
class Photo {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Api\\Photo";

    /**
     * 提交最终成片[看片完成]
     * @return  mixed
    */
    public static function submitFinalFilm (\Mainto\Bridge\Structs\ProjectCloud\Objects\Stream\SubmitFinalFilmParams $submitFinalFilmParams) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitFinalFilm($submitFinalFilmParams);
    }
    /**
     * 清空流水－顾客满意片
     * @return  bool
    */
    public static function clearFinishPhoto (string $streamNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearFinishPhoto(["streamNum" => $streamNum]);
    }
    /**
     * 清空照片－顾客满意片
     * @return  bool
    */
    public static function clearFinishPhotoByIds (string $streamNum, array $photoIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearFinishPhotoByIds(["streamNum" => $streamNum, "photoIds" => $photoIds]);
    }
    /**
     * 根据照片id批量获取照片信息
     * @return  mixed
    */
    public static function batchGetPhotoInfoById (array $ids, string $position = 'desc', string $version = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchGetPhotoInfoById(["ids" => $ids, "position" => $position, "version" => $version]);
    }
    /**
     * 根据照片id批量获取照片信息-包含订单信息
     * @return  mixed
    */
    public static function batchGetPhotoInfoByIds (array $ids, array $versions, string $extend = 'cloud_spot_check') {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchGetPhotoInfoByIds(["ids" => $ids, "versions" => $versions, "extend" => $extend]);
    }
    /**
     * 根据id获取照片信息
     * @return  mixed
    */
    public static function firstPhotoInfoById (int $id, string $position, string $version = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->firstPhotoInfoById(["id" => $id, "position" => $position, "version" => $version]);
    }
    /**
     * 批量获取订单照片信息-支持分页
     * @return  mixed
    */
    public static function batchPhotosAndPages (int $page = 1, int $pageSize = 10, array $externalNums, array $photoIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchPhotosAndPages(["page" => $page, "pageSize" => $pageSize, "externalNums" => $externalNums, "photoIds" => $photoIds]);
    }
    /**
     * 批量获取最终成片
     * @return  mixed
    */
    public static function batchGetFinishPhotosByOrderNum (array $externalNums) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchGetFinishPhotosByOrderNum(["externalNums" => $externalNums]);
    }
    /**
     * 增加在线看片最后更新版本
     * @return  mixed
    */
    public static function addOnlineUpdatePhotoVersion (array $photoData) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOnlineUpdatePhotoVersion(["photoData" => $photoData]);
    }
    /**
     * 完成本地上传照片
     * @return  bool
    */
    public static function finishIntranetPhoto (\Mainto\Bridge\Structs\ProjectCloud\Objects\Stream\FinishIntranetPhoto $finishIntranetPhoto) {
        return RpcClass::getClass(self::$serviceName, self::$className)->finishIntranetPhoto($finishIntranetPhoto);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}