<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-03 13:09:58
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Product";

    /**
     * 获取产品列表-2.26
     * @return  mixed
    */
    public static function getProductList (int $page = 1, int $pageSize = 10, int $photographerOrgId, array $productId, string $state, string $weightLevel, int $weightSettingId, array $productCategoryIdIn) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductList(["page" => $page, "pageSize" => $pageSize, "photographerOrgId" => $photographerOrgId, "productId" => $productId, "state" => $state, "weightLevel" => $weightLevel, "weightSettingId" => $weightSettingId, "productCategoryIdIn" => $productCategoryIdIn]);
    }
    /**
     * 审核通过--3.30.6
     * @return  mixed
    */
    public static function passProduct (int $productId, string $retouchStandard, string $weightLevel = 'weight_first', bool $needSplicing, bool $needTemplate, string $templateSuffix = 'jpg', array $normalIncomeConfig, array $splicingIncomeConfig, array $seaGrassConfig, array $splicingSeaGrassConfig, int $productCategoryId, bool $forceReview, string $forceReviewStartAt, string $forceReviewEndAt, string $forceReviewDayStart, string $forceReviewDayEnd, string $note, array $technicalPoints, array $textureName, int $weightSettingId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->passProduct(["productId" => $productId, "retouchStandard" => $retouchStandard, "weightLevel" => $weightLevel, "needSplicing" => $needSplicing, "needTemplate" => $needTemplate, "templateSuffix" => $templateSuffix, "normalIncomeConfig" => $normalIncomeConfig, "splicingIncomeConfig" => $splicingIncomeConfig, "seaGrassConfig" => $seaGrassConfig, "splicingSeaGrassConfig" => $splicingSeaGrassConfig, "productCategoryId" => $productCategoryId, "forceReview" => $forceReview, "forceReviewStartAt" => $forceReviewStartAt, "forceReviewEndAt" => $forceReviewEndAt, "forceReviewDayStart" => $forceReviewDayStart, "forceReviewDayEnd" => $forceReviewDayEnd, "note" => $note, "technicalPoints" => $technicalPoints, "textureName" => $textureName, "weightSettingId" => $weightSettingId]);
    }
    /**
     * 修改产品--2.30.6
     * @return  mixed
    */
    public static function editProduct (int $productId, string $retouchStandard, string $weightLevel, bool $needSplicing, bool $needTemplate, string $templateSuffix = 'jpg', array $normalIncomeConfig, array $splicingIncomeConfig, array $seaGrassConfig, array $splicingSeaGrassConfig, int $productCategoryId, string $note, bool $forceReview, string $forceReviewStartAt, string $forceReviewEndAt, string $forceReviewDayStart, string $forceReviewDayEnd, array $textureName, int $weightSettingId, array $technicalPoints) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editProduct(["productId" => $productId, "retouchStandard" => $retouchStandard, "weightLevel" => $weightLevel, "needSplicing" => $needSplicing, "needTemplate" => $needTemplate, "templateSuffix" => $templateSuffix, "normalIncomeConfig" => $normalIncomeConfig, "splicingIncomeConfig" => $splicingIncomeConfig, "seaGrassConfig" => $seaGrassConfig, "splicingSeaGrassConfig" => $splicingSeaGrassConfig, "productCategoryId" => $productCategoryId, "note" => $note, "forceReview" => $forceReview, "forceReviewStartAt" => $forceReviewStartAt, "forceReviewEndAt" => $forceReviewEndAt, "forceReviewDayStart" => $forceReviewDayStart, "forceReviewDayEnd" => $forceReviewDayEnd, "textureName" => $textureName, "weightSettingId" => $weightSettingId, "technicalPoints" => $technicalPoints]);
    }
    /**
     * 审核拒绝
     * @return  mixed
    */
    public static function refuseProduct (int $productId, string $refuseReason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refuseProduct(["productId" => $productId, "refuseReason" => $refuseReason]);
    }
    /**
     * 删除
     * @return  mixed
    */
    public static function delProduct (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delProduct(["productId" => $productId]);
    }
    /**
     * 获取产品详情--2.27
     * @return  mixed
    */
    public static function getProductInfo (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductInfo(["productId" => $productId]);
    }
    /**
     * searchProducts
     * @return  mixed
    */
    public static function searchProducts (array $photographerOrgIds = [], array $retouchStandards = [], bool $needDeleted = false, bool $productCategoryIdIn) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchProducts(["photographerOrgIds" => $photographerOrgIds, "retouchStandards" => $retouchStandards, "needDeleted" => $needDeleted, "productCategoryIdIn" => $productCategoryIdIn]);
    }
    /**
     * 获取队列权重类别列表(分页)----2.26更新
     * @return  mixed
    */
    public static function getQueueWeightTypeList (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getQueueWeightTypeList(["page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取所有队列权重类别列表----2.26更新
     * @return  mixed
    */
    public static function getAllQueueWeightType () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllQueueWeightType();
    }
    /**
     * 队列权重类别添加----2.26更新
     * @return  int
    */
    public static function addQueueWeightType (string $name, int $weight, int $increase_weight, int $urgent_weight, array $customer_urgent_weight, \Mainto\Bridge\Structs\ProjectCloud\Product\AddQueueWeightTypeParamsTakePhotoTimeSet $take_photo_time_set, int $critical_increase_weight, \Mainto\Bridge\Structs\ProjectCloud\Product\AddQueueWeightTypeParamsCriticalTakePhotoTime $critical_take_photo_time) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addQueueWeightType(["name" => $name, "weight" => $weight, "increase_weight" => $increase_weight, "urgent_weight" => $urgent_weight, "customer_urgent_weight" => $customer_urgent_weight, "take_photo_time_set" => $take_photo_time_set, "critical_increase_weight" => $critical_increase_weight, "critical_take_photo_time" => $critical_take_photo_time]);
    }
    /**
     * 队列权重类别编辑----2.26更新
     * @return  int
    */
    public static function editQueueWeightType (int $id, string $name, int $weight, int $increase_weight, int $urgent_weight, array $customer_urgent_weight, \Mainto\Bridge\Structs\ProjectCloud\Product\EditQueueWeightTypeParamsTakePhotoTimeSet $take_photo_time_set, int $critical_increase_weight, \Mainto\Bridge\Structs\ProjectCloud\Product\EditQueueWeightTypeParamsCriticalTakePhotoTime $critical_take_photo_time) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editQueueWeightType(["id" => $id, "name" => $name, "weight" => $weight, "increase_weight" => $increase_weight, "urgent_weight" => $urgent_weight, "customer_urgent_weight" => $customer_urgent_weight, "take_photo_time_set" => $take_photo_time_set, "critical_increase_weight" => $critical_increase_weight, "critical_take_photo_time" => $critical_take_photo_time]);
    }
    /**
     * 刷新队列----2.26更新
     * @return  bool
    */
    public static function refreshQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->refreshQueue();
    }
    /**
     * 是否能刷新队列----2.26更新
     * @return  int
    */
    public static function canRefreshQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->canRefreshQueue();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}