<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-11 17:18:58
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PhotoPool
 */
class PhotoPool {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "PhotoPool";

    /**
     * 获取客片列表
     * @return  mixed
    */
    public static function getPhotoList (int $page = 1, int $pageSize = 10, string $startAt, string $endAt, array $staffIds, string $streamNum, string $orderNum, string $customerName, string $telephone, string $photoVersion, array $productIds, array $retouchStandards, int $evaluateStar) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoList(["page" => $page, "pageSize" => $pageSize, "startAt" => $startAt, "endAt" => $endAt, "staffIds" => $staffIds, "streamNum" => $streamNum, "orderNum" => $orderNum, "customerName" => $customerName, "telephone" => $telephone, "photoVersion" => $photoVersion, "productIds" => $productIds, "retouchStandards" => $retouchStandards, "evaluateStar" => $evaluateStar]);
    }
    /**
     * 获取客片列表
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolListDTO
    */
    public static function getPhotoListV2 (\Mainto\Bridge\Structs\ProjectCloud\CMD\SearchPoolPhotoCMD $searchPoolPhotoCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPhotoListV2($searchPoolPhotoCMD),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolListDTO"
        );
    }
    /**
     * 获取客片详情
     * @return  mixed
    */
    public static function getPhotoInfo (string $photoUuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoInfo(["photoUuid" => $photoUuid]);
    }
    /**
     * 获取客片详情V2
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolInfoDTO
    */
    public static function getPhotoInfoV2 (string $photoId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPhotoInfoV2(["photoId" => $photoId]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolInfoDTO"
        );
    }
    /**
     * 提交【踩/赞】
     * @return  mixed
    */
    public static function submitAttitude (int $photoId, string $attitude) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitAttitude(["photoId" => $photoId, "attitude" => $attitude]);
    }
    /**
     * 提交【踩/赞】V2
     * @return  mixed
    */
    public static function submitAttitudeV2 (string $photoId, string $attitude) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitAttitudeV2(["photoId" => $photoId, "attitude" => $attitude]);
    }
    /**
     * 获取赞或踩客片详情
     * @return  mixed
    */
    public static function getAttitudePhotoInfo (string $photoUuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAttitudePhotoInfo(["photoUuid" => $photoUuid]);
    }
    /**
     * 获取赞或踩客片详情V2
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolAttitudeInfoDTO
    */
    public static function getAttitudePhotoInfoV2 (string $photoId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAttitudePhotoInfoV2(["photoId" => $photoId]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolAttitudeInfoDTO"
        );
    }
    /**
     * 获取优秀/问题客片列表
     * @return  mixed
    */
    public static function getAttitudePhotoList (string $startAt, string $endAt, string $attitude, int $page = 1, int $pageSize = 10, array $staffIds, array $productId, string $retouchStandard) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAttitudePhotoList(["startAt" => $startAt, "endAt" => $endAt, "attitude" => $attitude, "page" => $page, "pageSize" => $pageSize, "staffIds" => $staffIds, "productId" => $productId, "retouchStandard" => $retouchStandard]);
    }
    /**
     * 获取优秀/问题客片列表V2
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolAttitudeListDTO
    */
    public static function getAttitudePhotoListV2 (\Mainto\Bridge\Structs\ProjectCloud\CMD\SearchAttitudePoolPhotoCMD $searchAttitudePoolPhotoCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAttitudePhotoListV2($searchAttitudePoolPhotoCMD),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolAttitudeListDTO"
        );
    }
    /**
     * 获取照片流水与照片信息
     * @return  mixed
    */
    public static function getPhotoStreamInfo (string $imagePath) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoStreamInfo(["imagePath" => $imagePath]);
    }
    /**
     * 获取相似照片列表
     * @return  mixed
    */
    public static function getSimilarPhotoList (string $imageKey, int $top = 5) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSimilarPhotoList(["imageKey" => $imageKey, "top" => $top]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}