<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-15 17:59:41
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class GoalRewardConfig
 * @method getGoalRewardProductsByParams(array $params) 超修奖励配置 - 可选产品列表
 * @method getGoalRewardListByParams(array $params) 超修奖励配置列表
 * @method addGoalRewardConfigByParams(array $params) 新增超修奖励配置
 * @method editGoalRewardConfigByParams(array $params) 修改超修奖励配置
 * @method getGoalRewardDetailByParams(array $params) 超修奖励配置详情
 * @method delGoalRewardConfigByParams(array $params) 超修奖励配置删除
 * @method endGoalRewardConfigByParams(array $params) 提前结束
 */
class GoalRewardConfig {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "GoalRewardConfig";

    /**
     * 超修奖励配置 - 可选产品列表
     * @return  array
    */
    public static function getGoalRewardProducts (\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\GoalRewardProductCMD $goalRewardProductCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getGoalRewardProducts($goalRewardProductCMD),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\GoalRewardConfig\GoalRewardProductGroupDTO[]"
        );
    }

    /**
     * 超修奖励配置列表
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\GoalRewardConfig\GoalRewardListPageDTO
    */
    public static function getGoalRewardList (?\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\GoalRewardListCMD $goalRewardListCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getGoalRewardList($goalRewardListCMD),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\GoalRewardConfig\GoalRewardListPageDTO"
        );
    }

    /**
     * 新增超修奖励配置
     * @return  int
    */
    public static function addGoalRewardConfig (\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\AddGoalRewardConfigCMD $addGoalRewardConfigCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addGoalRewardConfig($addGoalRewardConfigCMD);
    }

    /**
     * 修改超修奖励配置
     * @return  bool
    */
    public static function editGoalRewardConfig (\Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig\EditGoalRewardConfigCMD $editGoalRewardConfigCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editGoalRewardConfig($editGoalRewardConfigCMD);
    }

    /**
     * 超修奖励配置详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\GoalRewardConfig\GoalRewardDetailDTO
    */
    public static function getGoalRewardDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getGoalRewardDetail(["id" => $id]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\GoalRewardConfig\GoalRewardDetailDTO"
        );
    }

    /**
     * 超修奖励配置删除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delGoalRewardConfig (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delGoalRewardConfig(["id" => $id]);
    }

    /**
     * 提前结束
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function endGoalRewardConfig (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->endGoalRewardConfig(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}