<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-23 15:57:54
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Retoucher
 * @method submitStreamByParams(array $params) 提交已修流水
 * @method joinQueueByParams(array $params) 进入队列
 * @method exitQueueByParams(array $params) 退出队列
 * @method receiptStreamByParams(array $params) 主动接单
 * @method tagStreamByParams(array $params) 流水打标签【作为认领的标记】
 */
class Retoucher {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Api\\Retoucher";

    /**
     * 提交已修流水
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function submitStream (string $streamNum, array $photoData, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitStream(array_merge($_params, ["streamNum" => $streamNum, "photoData" => $photoData]));
    }

    /**
     * 进入队列
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function joinQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->joinQueue();
    }

    /**
     * 退出队列
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function exitQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exitQueue();
    }

    /**
     * 主动接单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function receiptStream () {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiptStream();
    }

    /**
     * 流水打标签【作为认领的标记】
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function tagStream (string $streamNum, string $retoucherName, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->tagStream(array_merge($_params, ["streamNum" => $streamNum, "retoucherName" => $retoucherName]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}