<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-20 12:48:51
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\Note;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Note
 * @method questionListByParams(array $params) 问题列表
 * @method answerQuestionNoteByParams(array $params) 按照提交的答案获取展示需要的数据
 * @method answerQuestionNoteByStreamNumByParams(array $params) 按streamNum查询获取展示需要的数据
 * @method batchAnswerQuestionNoteByParams(array $params) 批量按照提交的答案获取展示需要的数据
 * @method answerQuestionNoteByStreamNumListByParams(array $params) 按streamNums批量查询获取展示需要的数据-每次最多500条，超过请分批调用
 */
class Note {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Note\\Note";

    /**
     * 问题列表
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\Note\QuestionListDTO
    */
    public static function questionList (?\Mainto\Bridge\Structs\ProjectCloud\CMD\Question\QuestionListCMD $questionListCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->questionList($questionListCMD),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\Note\QuestionListDTO"
        );
    }

    /**
     * 按照提交的答案获取展示需要的数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function answerQuestionNote (array $answer, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->answerQuestionNote(array_merge($_params, ["answer" => $answer]));
    }

    /**
     * 按streamNum查询获取展示需要的数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function answerQuestionNoteByStreamNum (string $streamNum, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->answerQuestionNoteByStreamNum(array_merge($_params, ["streamNum" => $streamNum]));
    }

    /**
     * 批量按照提交的答案获取展示需要的数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function batchAnswerQuestionNote (array $answers, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchAnswerQuestionNote(array_merge($_params, ["answers" => $answers]));
    }

    /**
     * 按streamNums批量查询获取展示需要的数据-每次最多500条，超过请分批调用
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function answerQuestionNoteByStreamNumList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->answerQuestionNoteByStreamNumList(array_merge($_params, []));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}