<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-17 10:38:08
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Staff
 * @method getStaffListByPageByParams(array $params) 获取账号列表
 * @method getStaffInfoByParams(array $params) 获取伙伴信息
 * @method searchStaffInfoByParams(array $params) 查询伙伴信息
 * @method getStaffPermissionByParams(array $params) 查询伙伴权限信息
 * @method addStaffByParams(array $params) 添加伙伴 ----2.6更新
 * @method editStaffByParams(array $params) 编辑伙伴 ----2.6更新
 * @method enableStaffByParams(array $params) 启用伙伴
 * @method disableStaffByParams(array $params) 禁用伙伴
 * @method addRetoucherClassByParams(array $params) 添加修片师类别
 * @method editRetoucherClassByParams(array $params) 编辑修片师类别
 * @method delRetoucherClassByParams(array $params) 删除修片师类别
 * @method getLevelListByParams(array $params) 获取等级列表
 * @method getAllLevelExpByParams(array $params) 获取各等级升级经验值
 * @method getIdentityListByParams(array $params) 获取修图身份列表
 * @method getRetoucherClassInfoByParams(array $params) 获取修片师类别
 * @method getRetoucherClassListByParams(array $params) 获取修片师类别列表
 * @method addRoleByParams(array $params) 添加角色
 * @method editRoleByParams(array $params) 编辑角色权限
 * @method delRoleByParams(array $params) 删除角色
 * @method getRoleInfoByParams(array $params) 获取角色信息
 * @method getRoleListByParams(array $params) 获取角色列表
 * @method getPermissionListByParams(array $params) 获取所有权限列表
 * @method getCanScoreStaffsByParams(array $params) 获取可打分伙伴s
 * @method batchSaveStaffScoresByParams(array $params) 批量保存staff打分信息
 * @method editStaffScoreByParams(array $params) 编辑staff分数
 * @method getStaffScoresByParams(array $params) 获取Staff分数列表
 * @method getGroupScoreRanksByParams(array $params) 个人中心组长－个人绩效－获取月度绩效排名分数数据
 * @method getGroupScoresByParams(array $params) 云端绩效查询－修图组绩效查询－－－2.8
 * @method getStaffLevelLogByParams(array $params) 用户升级情况查询 －－－ 2.12
 * @method getStaffProductByStaffIdByParams(array $params) 获取单个修图师的可接产品权限(出参所有产品)
 * @method cloudXiuKanShiStaffListByParams(array $params) 获取云端修看师列表
 * @method addCloudXiuKanShiByParams(array $params) 添加云端修看师
 * @method deleteCloudXiuKanShiByParams(array $params) 删除云端修看师
 */
class Staff {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Staff";

    /**
     * 获取账号列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffListByPage (string $staffName = '', int $roleId = 0, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffListByPage(["staffName" => $staffName, "roleId" => $roleId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 获取伙伴信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffInfo (int $staffNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffInfo(["staffNum" => $staffNum]);
    }

    /**
     * 查询伙伴信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function searchStaffInfo (int $staffNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchStaffInfo(["staffNum" => $staffNum]);
    }

    /**
     * 查询伙伴权限信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffPermission (int $staffNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffPermission(["staffNum" => $staffNum]);
    }

    /**
     * 添加伙伴 ----2.6更新
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addStaff (int $retoucherClass, int $roleId, array $permissionIds, int $level, float $exp, string $identity, int $staffNum, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addStaff(array_merge($_params, ["retoucherClass" => $retoucherClass, "roleId" => $roleId, "permissionIds" => $permissionIds, "level" => $level, "exp" => $exp, "identity" => $identity, "staffNum" => $staffNum]));
    }

    /**
     * 编辑伙伴 ----2.6更新
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function editStaff (int $staffNum, int $retoucherClass, int $roleId, int $level, float $exp, string $identity, array $permissionIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStaff(array_merge($_params, ["staffNum" => $staffNum, "retoucherClass" => $retoucherClass, "roleId" => $roleId, "level" => $level, "exp" => $exp, "identity" => $identity, "permissionIds" => $permissionIds]));
    }

    /**
     * 启用伙伴
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function enableStaff (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enableStaff(["staffId" => $staffId]);
    }

    /**
     * 禁用伙伴
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function disableStaff (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->disableStaff(["staffId" => $staffId]);
    }

    /**
     * 添加修片师类别
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addRetoucherClass (string $name, array $productIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addRetoucherClass(array_merge($_params, ["name" => $name, "productIds" => $productIds]));
    }

    /**
     * 编辑修片师类别
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function editRetoucherClass (string $name, array $productIds, int $retoucherClassId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editRetoucherClass(array_merge($_params, ["name" => $name, "productIds" => $productIds, "retoucherClassId" => $retoucherClassId]));
    }

    /**
     * 删除修片师类别
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delRetoucherClass (int $retoucherClassId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delRetoucherClass(["retoucherClassId" => $retoucherClassId]);
    }

    /**
     * 获取等级列表
     * @return  mixed
    */
    public static function getLevelList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLevelList();
    }

    /**
     * 获取各等级升级经验值
     * @return  mixed
    */
    public static function getAllLevelExp () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllLevelExp();
    }

    /**
     * 获取修图身份列表
     * @return  array
    */
    public static function getIdentityList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getIdentityList();
    }

    /**
     * 获取修片师类别
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getRetoucherClassInfo (int $retoucherClassId, bool $additionInfo = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetoucherClassInfo(["retoucherClassId" => $retoucherClassId, "additionInfo" => $additionInfo]);
    }

    /**
     * 获取修片师类别列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getRetoucherClassList (int $retouchClassId = 0, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetoucherClassList(["retouchClassId" => $retouchClassId, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 添加角色
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addRole (string $title, array $permissionIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addRole(array_merge($_params, ["title" => $title, "permissionIds" => $permissionIds]));
    }

    /**
     * 编辑角色权限
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function editRole (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editRole(array_merge($_params, []));
    }

    /**
     * 删除角色
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delRole (int $roleId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delRole(["roleId" => $roleId]);
    }

    /**
     * 获取角色信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getRoleInfo (int $roleId, bool $additionInfo = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRoleInfo(["roleId" => $roleId, "additionInfo" => $additionInfo]);
    }

    /**
     * 获取角色列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getRoleList (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRoleList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 获取所有权限列表
     * @return  mixed
    */
    public static function getPermissionList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPermissionList();
    }

    /**
     * 获取可打分伙伴s
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getCanScoreStaffs (string $type, int $groupId = 0, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCanScoreStaffs(array_merge($_params, ["type" => $type, "groupId" => $groupId]));
    }

    /**
     * 批量保存staff打分信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function batchSaveStaffScores (int $groupId, array $staffScores, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSaveStaffScores(array_merge($_params, ["groupId" => $groupId, "staffScores" => $staffScores]));
    }

    /**
     * 编辑staff分数
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function editStaffScore (int $groupId, int $id, float $score, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStaffScore(array_merge($_params, ["groupId" => $groupId, "id" => $id, "score" => $score]));
    }

    /**
     * 获取Staff分数列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStaffScores (string $type, string $cycle, int $groupId, int $page = 1, int $pageSize = 20, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffScores(array_merge($_params, ["type" => $type, "cycle" => $cycle, "groupId" => $groupId, "page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 个人中心组长－个人绩效－获取月度绩效排名分数数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getGroupScoreRanks (string $type, int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupScoreRanks(array_merge($_params, ["type" => $type, "page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 云端绩效查询－修图组绩效查询－－－2.8
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getGroupScores (string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupScores(["startAt" => $startAt, "endAt" => $endAt]);
    }

    /**
     * 用户升级情况查询 －－－ 2.12
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffLevelLog (string $date, int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffLevelLog(["date" => $date, "staffId" => $staffId]);
    }

    /**
     * 获取单个修图师的可接产品权限(出参所有产品)
     * @return  array
    */
    public static function getStaffProductByStaffId (\Mainto\Bridge\Structs\ProjectCloud\CMD\GetStaffProductByStaffIdCMD $getStaffProductByStaffIdCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStaffProductByStaffId($getStaffProductByStaffIdCMD),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\GetStaffProductByStaffIdDTO[]"
        );
    }

    /**
     * 获取云端修看师列表
     * @return  mixed
    */
    public static function cloudXiuKanShiStaffList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cloudXiuKanShiStaffList();
    }

    /**
     * 添加云端修看师
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  int
    */
    public static function addCloudXiuKanShi (array $staffIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addCloudXiuKanShi(array_merge($_params, ["staffIds" => $staffIds]));
    }

    /**
     * 删除云端修看师
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  int
    */
    public static function deleteCloudXiuKanShi (array $staffIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteCloudXiuKanShi(array_merge($_params, ["staffIds" => $staffIds]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}