<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-25 12:56:22
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ReworkPool
 * @method getScoreScaleByParams(array $params) 获取评分档位
 * @method takeItemByParams(array $params) 抽片
 * @method getHaveSpotCheckResultByParams(array $params) 获取是否有未评分的抽片
 * @method getSpotCheckResultByParams(array $params) 获取抽片结果
 * @method getSearchHistoryByParams(array $params) 获取抽片历史记录
 * @method getStatisticsByParams(array $params) 获取今日抽片指标
 * @method commitHistoryByParams(array $params) 提交评价
 * @method updateCommitHistoryByParams(array $params) 修改提交评价
 * @method getUpdateCommitHistoryLogByParams(array $params) 获取更新修改提交评价记录
 * @method fixCheckPoolConfigByParams(array $params) 抽片池配置修改-test
 * @method isCheckPoolExperimentByParams(array $params) 抽片试点
 */
class ReworkPool {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "CheckPool\\ReworkPool";

    /**
     * 获取评分档位
     * @return  array
    */
    public static function getScoreScale () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getScoreScale(),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\CheckPool\ScoreScaleDTO[]"
        );
    }

    /**
     * 抽片
     * @return  string
    */
    public static function takeItem (\Mainto\Bridge\Structs\ProjectCloud\Objects\CheckPool\TakeItem $takeItem) {
        return RpcClass::getClass(self::$serviceName, self::$className)->takeItem($takeItem);
    }

    /**
     * 获取是否有未评分的抽片
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getHaveSpotCheckResult () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHaveSpotCheckResult();
    }

    /**
     * 获取抽片结果
     * @return  array
    */
    public static function getSpotCheckResult (\Mainto\Bridge\Structs\ProjectCloud\Objects\CheckPool\GetSpotCheckResult $getSpotCheckResult) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSpotCheckResult($getSpotCheckResult);
    }

    /**
     * 获取抽片历史记录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getSearchHistory (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSearchHistory(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 获取今日抽片指标
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStatistics () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStatistics();
    }

    /**
     * 提交评价
     * @return  bool
    */
    public static function commitHistory (\Mainto\Bridge\Structs\ProjectCloud\Objects\CheckPool\CommitHistory $commitHistory) {
        return RpcClass::getClass(self::$serviceName, self::$className)->commitHistory($commitHistory);
    }

    /**
     * 修改提交评价
     * @return  bool
    */
    public static function updateCommitHistory (\Mainto\Bridge\Structs\ProjectCloud\Objects\CheckPool\UpdateHistory $updateHistory) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCommitHistory($updateHistory);
    }

    /**
     * 获取更新修改提交评价记录
     * @return  array
    */
    public static function getUpdateCommitHistoryLog (\Mainto\Bridge\Structs\ProjectCloud\Objects\CheckPool\UpdateCommitHistoryLog $updateCommitHistoryLog) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUpdateCommitHistoryLog($updateCommitHistoryLog);
    }

    /**
     * 抽片池配置修改-test
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function fixCheckPoolConfig (array $configData) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixCheckPoolConfig(["configData" => $configData]);
    }

    /**
     * 抽片试点
     * @return  bool
    */
    public static function isCheckPoolExperiment () {
        return RpcClass::getClass(self::$serviceName, self::$className)->isCheckPoolExperiment();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}