<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-28 19:51:45
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Product
 * @method addProductByParams(array $params) 创建产品
 * @method disableProductByParams(array $params) 禁用产品
 * @method enableProductByParams(array $params) 启用产品
 * @method getProductListByIdsByParams(array $params) 批量获取产品信息
 * @method editProductNameByParams(array $params) 修改产品名称
 * @method getProductInfoByParams(array $params) 获取产品详情
 * @method getProductInfoByIdsByParams(array $params) 通过ids获取产品信息
 * @method copyProductByParams(array $params) 复制产品
 * @method getOutProductsStateByParams(array $params) 批量查询产品状态-外部
 * @method addOutProductByParams(array $params) 创建产品外部通知
 */
class Product {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Api\\Product";

    /**
     * 创建产品
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addProduct (string $name, string $retouchRequire, array $simpleImages, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addProduct(array_merge($_params, ["name" => $name, "retouchRequire" => $retouchRequire, "simpleImages" => $simpleImages]));
    }

    /**
     * 禁用产品
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function disableProduct (int $productId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->disableProduct(array_merge($_params, ["productId" => $productId]));
    }

    /**
     * 启用产品
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function enableProduct (int $productId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enableProduct(array_merge($_params, ["productId" => $productId]));
    }

    /**
     * 批量获取产品信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductListByIds (array $productIds, int $page = 1, int $pageSize = 10, int $photographerOrgId, array $columns = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductListByIds(["productIds" => $productIds, "page" => $page, "pageSize" => $pageSize, "photographerOrgId" => $photographerOrgId, "columns" => $columns]);
    }

    /**
     * 修改产品名称
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function editProductName (int $productId, string $name, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editProductName(array_merge($_params, ["productId" => $productId, "name" => $name]));
    }

    /**
     * 获取产品详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductInfo (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductInfo(["productId" => $productId]);
    }

    /**
     * 通过ids获取产品信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductInfoByIds (array $productIds, array $columns = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductInfoByIds(["productIds" => $productIds, "columns" => $columns]);
    }

    /**
     * 复制产品
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function copyProduct (int $productId, array $updates = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->copyProduct(array_merge($_params, ["productId" => $productId, "updates" => $updates]));
    }

    /**
     * 批量查询产品状态-外部
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getOutProductsState (array $outProductIds, string $from) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOutProductsState(["outProductIds" => $outProductIds, "from" => $from]);
    }

    /**
     * 创建产品外部通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function addOutProduct (string $name, int $photographerOrgId, int $skuId, array $simpleImages = [], string $retouchRequire = '', string $from = 'pbc') {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOutProduct(["name" => $name, "photographerOrgId" => $photographerOrgId, "skuId" => $skuId, "simpleImages" => $simpleImages, "retouchRequire" => $retouchRequire, "from" => $from]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}