<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-27 20:44:11
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class RetouchDemand
 * @method getRetouchStylesByParams(array $params) 获取修图风格列表
 * @method getRetouchStylesV2ByParams(array $params) 获取修图风格列表
 * @method getTechnicalPointsByParams(array $params) 获取产品下所有技术要点
 * @method submitRetouchStandardByParams(array $params) 提交修图满意度
 * @method getRetoucherByOrderNumByParams(array $params) 根据订单号获取修图师
 */
class RetouchDemand {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Api\\RetouchDemand";

    /**
     * 获取修图风格列表
     * @return  array
    */
    public static function getRetouchStyles () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchStyles();
    }

    /**
     * 获取修图风格列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getRetouchStylesV2 (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchStylesV2(["productId" => $productId]);
    }

    /**
     * 获取产品下所有技术要点
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getTechnicalPoints (bool $needDelete = false, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTechnicalPoints(array_merge($_params, ["needDelete" => $needDelete]));
    }

    /**
     * 提交修图满意度
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function submitRetouchStandard (string $streamNum, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitRetouchStandard(array_merge($_params, ["streamNum" => $streamNum]));
    }

    /**
     * 根据订单号获取修图师
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getRetoucherByOrderNum (string $orderNum, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetoucherByOrderNum(array_merge($_params, ["orderNum" => $orderNum]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}