<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-05 19:55:37
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Product
 * @method getProductListByParams(array $params) 获取产品列表-2.26
 * @method passProductByParams(array $params) 审核通过--3.30.6
 * @method editProductByParams(array $params) 修改产品--2.30.6
 * @method refuseProductByParams(array $params) 审核拒绝
 * @method delProductByParams(array $params) 删除
 * @method getProductInfoByParams(array $params) 获取产品详情--2.27
 * @method searchProductsByParams(array $params) searchProducts
 * @method getQueueWeightTypeListByParams(array $params) 获取队列权重类别列表(分页)----2.26更新
 * @method getAllQueueWeightTypeByParams(array $params) 获取所有队列权重类别列表----2.26更新
 * @method addQueueWeightTypeByParams(array $params) 队列权重类别添加----2.26更新
 * @method editQueueWeightTypeByParams(array $params) 队列权重类别编辑----2.26更新
 * @method refreshQueueByParams(array $params) 刷新队列----2.26更新
 * @method canRefreshQueueByParams(array $params) 是否能刷新队列----2.26更新
 */
class Product {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Product";

    /**
     * 获取产品列表-2.26
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getProductList (int $page = 1, int $pageSize = 10, string $state, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize, "state" => $state]));
    }

    /**
     * 审核通过--3.30.6
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function passProduct (int $productId, string $weightLevel = 'weight_first', bool $needSplicing, bool $needTemplate, string $templateSuffix = 'jpg', array $normalIncomeConfig, array $seaGrassConfig, int $productCategoryId, bool $forceReview, int $needTrialRepair = 0, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->passProduct(array_merge($_params, ["productId" => $productId, "weightLevel" => $weightLevel, "needSplicing" => $needSplicing, "needTemplate" => $needTemplate, "templateSuffix" => $templateSuffix, "normalIncomeConfig" => $normalIncomeConfig, "seaGrassConfig" => $seaGrassConfig, "productCategoryId" => $productCategoryId, "forceReview" => $forceReview, "needTrialRepair" => $needTrialRepair]));
    }

    /**
     * 修改产品--2.30.6
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function editProduct (int $productId, string $templateSuffix = 'jpg', int $needTrialRepair = 0, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editProduct(array_merge($_params, ["productId" => $productId, "templateSuffix" => $templateSuffix, "needTrialRepair" => $needTrialRepair]));
    }

    /**
     * 审核拒绝
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function refuseProduct (int $productId, string $refuseReason) {
        return RpcClass::getClass(self::$serviceName, self::$className)->refuseProduct(["productId" => $productId, "refuseReason" => $refuseReason]);
    }

    /**
     * 删除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delProduct (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delProduct(["productId" => $productId]);
    }

    /**
     * 获取产品详情--2.27
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductInfo (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductInfo(["productId" => $productId]);
    }

    /**
     * searchProducts
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function searchProducts (array $photographerOrgIds = [], array $retouchStandards = [], bool $needDeleted = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchProducts(["photographerOrgIds" => $photographerOrgIds, "retouchStandards" => $retouchStandards, "needDeleted" => $needDeleted]);
    }

    /**
     * 获取队列权重类别列表(分页)----2.26更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getQueueWeightTypeList (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getQueueWeightTypeList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 获取所有队列权重类别列表----2.26更新
     * @return  mixed
    */
    public static function getAllQueueWeightType () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllQueueWeightType();
    }

    /**
     * 队列权重类别添加----2.26更新
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  int
    */
    public static function addQueueWeightType (int $weight, int $increase_weight, int $urgent_weight, int $store_top_weight, array $customer_urgent_weight, \Mainto\Bridge\Structs\ProjectCloud\Product\AddQueueWeightTypeParamsTakePhotoTimeSet $take_photo_time_set, int $critical_increase_weight, \Mainto\Bridge\Structs\ProjectCloud\Product\AddQueueWeightTypeParamsCriticalTakePhotoTime $critical_take_photo_time, int $trial_repair_weight, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addQueueWeightType(array_merge($_params, ["weight" => $weight, "increase_weight" => $increase_weight, "urgent_weight" => $urgent_weight, "store_top_weight" => $store_top_weight, "customer_urgent_weight" => $customer_urgent_weight, "take_photo_time_set" => $take_photo_time_set, "critical_increase_weight" => $critical_increase_weight, "critical_take_photo_time" => $critical_take_photo_time, "trial_repair_weight" => $trial_repair_weight]));
    }

    /**
     * 队列权重类别编辑----2.26更新
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  int
    */
    public static function editQueueWeightType (int $id, int $weight, int $increase_weight, int $urgent_weight, int $store_top_weight, array $customer_urgent_weight, \Mainto\Bridge\Structs\ProjectCloud\Product\EditQueueWeightTypeParamsTakePhotoTimeSet $take_photo_time_set, int $critical_increase_weight, \Mainto\Bridge\Structs\ProjectCloud\Product\EditQueueWeightTypeParamsCriticalTakePhotoTime $critical_take_photo_time, int $trial_repair_weight = 0, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editQueueWeightType(array_merge($_params, ["id" => $id, "weight" => $weight, "increase_weight" => $increase_weight, "urgent_weight" => $urgent_weight, "store_top_weight" => $store_top_weight, "customer_urgent_weight" => $customer_urgent_weight, "take_photo_time_set" => $take_photo_time_set, "critical_increase_weight" => $critical_increase_weight, "critical_take_photo_time" => $critical_take_photo_time, "trial_repair_weight" => $trial_repair_weight]));
    }

    /**
     * 刷新队列----2.26更新
     * @return  bool
    */
    public static function refreshQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->refreshQueue();
    }

    /**
     * 是否能刷新队列----2.26更新
     * @return  int
    */
    public static function canRefreshQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->canRefreshQueue();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}