<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-04 21:14:20
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Order
 * @method createOrderByParams(array $params) 创建订单
 * @method batchGetOrderInfoByParams(array $params) 批量获取订单信息
 * @method getOrderInfoByParams(array $params) 获取订单详情
 * @method getOrderInfoInnerByParams(array $params) 获取订单详情
 * @method closeOrderByParams(array $params) 关闭订单
 * @method getReworkStreamNumByExternalNumByParams(array $params) 根据订单号获取返修单流水号
 * @method getStreamNumRelReworkByParams(array $params) 根据订单号查询流水-退回流水关联
 * @method getTagsByOrderNumsByParams(array $params) 根据订单号获取标签
 */
class Order {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Api\\Order";

    /**
     * 创建订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function createOrder (string $externalNum, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrder(array_merge($_params, ["externalNum" => $externalNum]));
    }

    /**
     * 批量获取订单信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function batchGetOrderInfo (array $externalNums, int $needPhoto = 0, bool $withDeletedStream = true, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchGetOrderInfo(array_merge($_params, ["externalNums" => $externalNums, "needPhoto" => $needPhoto, "withDeletedStream" => $withDeletedStream]));
    }

    /**
     * 获取订单详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getOrderInfo (string $externalNum, bool $withDeletedStream = true, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderInfo(array_merge($_params, ["externalNum" => $externalNum, "withDeletedStream" => $withDeletedStream]));
    }

    /**
     * 获取订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getOrderInfoInner (int $orgId, string $externalNum, bool $withDeletedStream = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderInfoInner(["orgId" => $orgId, "externalNum" => $externalNum, "withDeletedStream" => $withDeletedStream]);
    }

    /**
     * 关闭订单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function closeOrder (string $externalNum, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeOrder(array_merge($_params, ["externalNum" => $externalNum]));
    }

    /**
     * 根据订单号获取返修单流水号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getReworkStreamNumByExternalNum (int $orgId, string $externalNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReworkStreamNumByExternalNum(["orgId" => $orgId, "externalNum" => $externalNum]);
    }

    /**
     * 根据订单号查询流水-退回流水关联
     * @return  array
    */
    public static function getStreamNumRelRework (\Mainto\Bridge\Structs\ProjectCloud\CMD\GetStreamNumRelReworkCMD $getStreamNumRelReworkCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStreamNumRelRework($getStreamNumRelReworkCMD),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\GetStreamNumRelReworkDTO[]"
        );
    }

    /**
     * 根据订单号获取标签
     * @return  array
    */
    public static function getTagsByOrderNums (\Mainto\Bridge\Structs\ProjectCloud\CMD\GetTagsByOrderNumsCMD $getTagsByOrderNumsCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getTagsByOrderNums($getTagsByOrderNumsCMD),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\GetTagsByOrderNumDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}