<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-30 21:28:26
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class TrialRepair
 * @method trialRepairConfigByParams(array $params) 试修配置
 * @method trialRepairDetailByParams(array $params) 试修配置详情
 * @method splitTrialRepairStreamByParams(array $params) 拆分试修流水
 * @method isCanTrialRepairByParams(array $params) 是否可以试修
 * @method imHistoryByParams(array $params) 试修流水看片聊天记录
 */
class TrialRepair {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "TrialRepair";

    /**
     * 试修配置
     * @return  bool
    */
    public static function trialRepairConfig (?\Mainto\Bridge\Structs\ProjectCloud\CMD\TrialRepair\TrialRepairConfigCMD $trialRepairConfigCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->trialRepairConfig($trialRepairConfigCMD);
    }

    /**
     * 试修配置详情
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\Stream\TrialRepairConfigDTO
    */
    public static function trialRepairDetail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->trialRepairDetail(),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\Stream\TrialRepairConfigDTO"
        );
    }

    /**
     * 拆分试修流水
     * @return  bool
    */
    public static function splitTrialRepairStream (\Mainto\Bridge\Structs\ProjectCloud\CMD\TrialRepair\SplitTrialRepairStreamCMD $splitTrialRepairStreamCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->splitTrialRepairStream($splitTrialRepairStreamCMD);
    }

    /**
     * 是否可以试修
     * @return  mixed
    */
    public static function isCanTrialRepair (\Mainto\Bridge\Structs\ProjectCloud\CMD\TrialRepair\IsCanTrialRepairCMD $isCanTrialRepairCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->isCanTrialRepair($isCanTrialRepairCMD);
    }

    /**
     * 试修流水看片聊天记录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function imHistory (string $orderNum, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->imHistory(array_merge($_params, ["orderNum" => $orderNum]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}