<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-17 17:58:24
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PhotoPool
 * @method getPhotoListByParams(array $params) 获取客片列表
 * @method getPhotoListV2ByParams(array $params) 获取客片列表
 * @method getPhotoInfoByParams(array $params) 获取客片详情
 * @method getPhotoInfoV2ByParams(array $params) 获取客片详情V2
 * @method submitAttitudeByParams(array $params) 提交【踩/赞】
 * @method submitAttitudeV2ByParams(array $params) 提交【踩/赞】V2
 * @method getAttitudePhotoInfoByParams(array $params) 获取赞或踩客片详情
 * @method getAttitudePhotoInfoV2ByParams(array $params) 获取赞或踩客片详情V2
 * @method getAttitudePhotoListByParams(array $params) 获取优秀/问题客片列表
 * @method getAttitudePhotoListV2ByParams(array $params) 获取优秀/问题客片列表V2
 * @method getPhotoStreamInfoByParams(array $params) 获取照片流水与照片信息
 * @method getSimilarPhotoListByParams(array $params) 获取相似照片列表
 */
class PhotoPool {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "PhotoPool";

    /**
     * 获取客片列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getPhotoList (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 获取客片列表
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolListDTO
    */
    public static function getPhotoListV2 (\Mainto\Bridge\Structs\ProjectCloud\CMD\SearchPoolPhotoCMD $searchPoolPhotoCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPhotoListV2($searchPoolPhotoCMD),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolListDTO"
        );
    }

    /**
     * 获取客片详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getPhotoInfo (string $photoUuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoInfo(["photoUuid" => $photoUuid]);
    }

    /**
     * 获取客片详情V2
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolInfoDTO
    */
    public static function getPhotoInfoV2 (string $photoId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPhotoInfoV2(["photoId" => $photoId]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolInfoDTO"
        );
    }

    /**
     * 提交【踩/赞】
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function submitAttitude (int $photoId, string $attitude, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitAttitude(array_merge($_params, ["photoId" => $photoId, "attitude" => $attitude]));
    }

    /**
     * 提交【踩/赞】V2
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function submitAttitudeV2 (string $photoId, string $attitude, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitAttitudeV2(array_merge($_params, ["photoId" => $photoId, "attitude" => $attitude]));
    }

    /**
     * 获取赞或踩客片详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAttitudePhotoInfo (string $photoUuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAttitudePhotoInfo(["photoUuid" => $photoUuid]);
    }

    /**
     * 获取赞或踩客片详情V2
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolAttitudeInfoDTO
    */
    public static function getAttitudePhotoInfoV2 (string $photoId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAttitudePhotoInfoV2(["photoId" => $photoId]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolAttitudeInfoDTO"
        );
    }

    /**
     * 获取优秀/问题客片列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getAttitudePhotoList (string $startAt, string $endAt, string $attitude, int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAttitudePhotoList(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt, "attitude" => $attitude, "page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 获取优秀/问题客片列表V2
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolAttitudeListDTO
    */
    public static function getAttitudePhotoListV2 (\Mainto\Bridge\Structs\ProjectCloud\CMD\SearchAttitudePoolPhotoCMD $searchAttitudePoolPhotoCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAttitudePhotoListV2($searchAttitudePoolPhotoCMD),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolAttitudeListDTO"
        );
    }

    /**
     * 获取照片流水与照片信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getPhotoStreamInfo (string $imagePath) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoStreamInfo(["imagePath" => $imagePath]);
    }

    /**
     * 获取相似照片列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSimilarPhotoList (string $imageKey, int $top = 5) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSimilarPhotoList(["imageKey" => $imageKey, "top" => $top]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}