<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-30 23:36:50
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Task
 * @method autoEndImpulseByParams(array $params) 自动结束冲量buff
 * @method expireImpulseByParams(array $params) 过期冲量奖
 * @method autoEndStaffCardByParams(array $params) 结束卡片
 * @method expireStaffCardByParams(array $params) 过期卡片
 * @method yearAwardByParams(array $params) 年终奖(小蜜蜂)
 * @method updateStreamTakeTimeByParams(array $params) 流水：隔日变当日
 * @method unbindRetoucherOrgStreamByParams(array $params) 30分钟释放外包机构
 * @method impulseAutoUsingByParams(array $params) 冲量自动开始
 * @method initRandomSequenceByParams(array $params) 生成第二日随机码
 * @method logQueueInfoByParams(array $params) 每日22,0点记录队列余量
 * @method staffLevelCheckByParams(array $params) 员工升降级检查
 * @method autoOfflineByParams(array $params) 自动离线
 * @method autoGroupRankFlushMonthByParams(array $params) 刷新组排名数据
 * @method autoStaffRankFlushMonthByParams(array $params) 刷新个人排名数据
 * @method autoGroupRankFlushDayByParams(array $params) 刷新每日组排名数据
 * @method autoExpireStreamAppealByParams(array $params) 自动将申诉过期
 * @method autoSendRetoucherLeaderAppealExamineByParams(array $params) 自动发送修图主管待初审通知
 * @method autoSendAppealManagerExamineByParams(array $params) 自动发送待复审通知
 * @method reportMonitorByParams(array $params) 监控
 * @method cacheAssignStreamByParams(array $params) 缓存指派流水
 * @method cacheTrialServiceStaffByParams(array $params) 试修可接人员缓存
 * @method cacheNoBuildGroupByParams(array $params) 缓存NoBuildGroup
 * @method refreshQueueByParams(array $params) 10min触发异步刷新队列权重
 * @method queueStreamStartByParams(array $params) 云端队列剩余单量 --- 早上八点
 * @method queueStreamByParams(array $params) 云端队列剩余处理 --- 晚上十点
 * @method sendKpiSetMessageByParams(array $params) 绩效导入截止日期通知
 * @method cacheAIStudyConfigByParams(array $params) 缓存AI学习-标示
 * @method pushAiAutoStreamByParams(array $params) 推送aiAuto流水
 * @method cacheAiAutoWaitReviewStreamIdsByParams(array $params) 缓存ai自动化的待审核流水
 * @method pushGoalRewardConfigStateQueueByParams(array $params) 更新超修激励配置状态
 * @method emptyReworkPoolByParams(array $params) 每月1号清除退回抽查池上个月未评分数据
 * @method clearCloudletStaffCacheByParams(array $params) 清除云朵修图师缓存
 * @method refreshWorkListQueueByParams(array $params) 10min触发异步刷新工作队列权重
 * @method migrateAssignStreamHistoryByParams(array $params) 11点迁移指派队列数据
 * @method imageSyncUploadByParams(array $params) 图像加速卡单脚本补发
 */
class Task {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Task";

    /**
     * 自动结束冲量buff
     * @return  mixed
    */
    public static function autoEndImpulse () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoEndImpulse();
    }

    /**
     * 过期冲量奖
     * @return  mixed
    */
    public static function expireImpulse () {
        return RpcClass::getClass(self::$serviceName, self::$className)->expireImpulse();
    }

    /**
     * 结束卡片
     * @return  mixed
    */
    public static function autoEndStaffCard () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoEndStaffCard();
    }

    /**
     * 过期卡片
     * @return  mixed
    */
    public static function expireStaffCard () {
        return RpcClass::getClass(self::$serviceName, self::$className)->expireStaffCard();
    }

    /**
     * 年终奖(小蜜蜂)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function yearAward (int $year = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->yearAward(["year" => $year]);
    }

    /**
     * 流水：隔日变当日
     * @return  mixed
    */
    public static function updateStreamTakeTime () {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStreamTakeTime();
    }

    /**
     * 30分钟释放外包机构
     * @return  mixed
    */
    public static function unbindRetoucherOrgStream () {
        return RpcClass::getClass(self::$serviceName, self::$className)->unbindRetoucherOrgStream();
    }

    /**
     * 冲量自动开始
     * @return  mixed
    */
    public static function impulseAutoUsing () {
        return RpcClass::getClass(self::$serviceName, self::$className)->impulseAutoUsing();
    }

    /**
     * 生成第二日随机码
     * @return  mixed
    */
    public static function initRandomSequence () {
        return RpcClass::getClass(self::$serviceName, self::$className)->initRandomSequence();
    }

    /**
     * 每日22,0点记录队列余量
     * @return  mixed
    */
    public static function logQueueInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->logQueueInfo();
    }

    /**
     * 员工升降级检查
     * @return  mixed
    */
    public static function staffLevelCheck () {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffLevelCheck();
    }

    /**
     * 自动离线
     * @return  mixed
    */
    public static function autoOffline () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoOffline();
    }

    /**
     * 刷新组排名数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function autoGroupRankFlushMonth (string $cycle = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoGroupRankFlushMonth(["cycle" => $cycle]);
    }

    /**
     * 刷新个人排名数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function autoStaffRankFlushMonth (string $cycle = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoStaffRankFlushMonth(["cycle" => $cycle]);
    }

    /**
     * 刷新每日组排名数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function autoGroupRankFlushDay (string $cycle = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoGroupRankFlushDay(["cycle" => $cycle]);
    }

    /**
     * 自动将申诉过期
     * @return  mixed
    */
    public static function autoExpireStreamAppeal () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoExpireStreamAppeal();
    }

    /**
     * 自动发送修图主管待初审通知
     * @return  mixed
    */
    public static function autoSendRetoucherLeaderAppealExamine () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoSendRetoucherLeaderAppealExamine();
    }

    /**
     * 自动发送待复审通知
     * @return  mixed
    */
    public static function autoSendAppealManagerExamine () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoSendAppealManagerExamine();
    }

    /**
     * 监控
     * @return  mixed
    */
    public static function reportMonitor () {
        return RpcClass::getClass(self::$serviceName, self::$className)->reportMonitor();
    }

    /**
     * 缓存指派流水
     * @return  bool
    */
    public static function cacheAssignStream () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cacheAssignStream();
    }

    /**
     * 试修可接人员缓存
     * @return  bool
    */
    public static function cacheTrialServiceStaff () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cacheTrialServiceStaff();
    }

    /**
     * 缓存NoBuildGroup
     * @return  bool
    */
    public static function cacheNoBuildGroup () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cacheNoBuildGroup();
    }

    /**
     * 10min触发异步刷新队列权重
     * @return  bool
    */
    public static function refreshQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->refreshQueue();
    }

    /**
     * 云端队列剩余单量 --- 早上八点
     * @return  mixed
    */
    public static function queueStreamStart () {
        return RpcClass::getClass(self::$serviceName, self::$className)->queueStreamStart();
    }

    /**
     * 云端队列剩余处理 --- 晚上十点
     * @return  mixed
    */
    public static function queueStream () {
        return RpcClass::getClass(self::$serviceName, self::$className)->queueStream();
    }

    /**
     * 绩效导入截止日期通知
     * @return  mixed
    */
    public static function sendKpiSetMessage () {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendKpiSetMessage();
    }

    /**
     * 缓存AI学习-标示
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function cacheAIStudyConfig (string $key = 'default') {
        return RpcClass::getClass(self::$serviceName, self::$className)->cacheAIStudyConfig(["key" => $key]);
    }

    /**
     * 推送aiAuto流水
     * @return  bool
    */
    public static function pushAiAutoStream () {
        return RpcClass::getClass(self::$serviceName, self::$className)->pushAiAutoStream();
    }

    /**
     * 缓存ai自动化的待审核流水
     * @return  bool
    */
    public static function cacheAiAutoWaitReviewStreamIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cacheAiAutoWaitReviewStreamIds();
    }

    /**
     * 更新超修激励配置状态
     * @return  void
    */
    public static function pushGoalRewardConfigStateQueue () {
         RpcClass::getClass(self::$serviceName, self::$className)->pushGoalRewardConfigStateQueue();
    }

    /**
     * 每月1号清除退回抽查池上个月未评分数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  void
    */
    public static function emptyReworkPool (int $staffId = null) {
         RpcClass::getClass(self::$serviceName, self::$className)->emptyReworkPool(["staffId" => $staffId]);
    }

    /**
     * 清除云朵修图师缓存
     * @return  void
    */
    public static function clearCloudletStaffCache () {
         RpcClass::getClass(self::$serviceName, self::$className)->clearCloudletStaffCache();
    }

    /**
     * 10min触发异步刷新工作队列权重
     * @return  bool
    */
    public static function refreshWorkListQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->refreshWorkListQueue();
    }

    /**
     * 11点迁移指派队列数据
     * @return  bool
    */
    public static function migrateAssignStreamHistory () {
        return RpcClass::getClass(self::$serviceName, self::$className)->migrateAssignStreamHistory();
    }

    /**
     * 图像加速卡单脚本补发
     * @return  mixed
    */
    public static function imageSyncUpload () {
        return RpcClass::getClass(self::$serviceName, self::$className)->imageSyncUpload();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}