<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-19 20:28:45
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Hook
 * @method createHimoNpsByParams(array $params) 监听创建NPS记录
 * @method outStreamWaitReviewByParams(array $params) outStreamWaitReview
 * @method outStreamWaitReviewedByParams(array $params) outStreamWaitReviewed
 * @method staffPositionUpdateByParams(array $params) staffPositionUpdate
 * @method hookQuotaEventByParams(array $params) hookQuotaEvent
 * @method hookRefreshQueueSyncByParams(array $params) hookRefreshQueueSync
 * @method hookStaffPassProductsByParams(array $params) hookStaffPassProducts
 * @method hookDelayReviewPassByParams(array $params) hookDelayReviewPass
 * @method hookPassConfigNotifyByParams(array $params) hookPassConfigNotify
 * @method hookLearningPlanExamFailByParams(array $params) hookLearningPlanExamFail
 * @method hookOnlineWatcherTakeOrderByParams(array $params) hookOnlineWatcherTakeOrder
 * @method hookWatchRecordFinishByParams(array $params) hookWatchRecordFinish
 * @method hookWatchRecordCloseByParams(array $params) hookWatchRecordClose
 * @method hookWatchRecordConfirmByParams(array $params) hookWatchRecordConfirm
 * @method hookFinishIntranetStreamByParams(array $params) hookFinishIntranetStream
 * @method hookGoalRewardConfigChangeStateByParams(array $params) 超修激励配置更改状态
 * @method hookStreamPassAddWaterMarkByParams(array $params) hookStreamPassAddWaterMark
 * @method hookSubmitPhotoByParams(array $params) 修图师提交修图
 * @method hookStreamPassAddCheckPoolByParams(array $params) 流水审核通过-进入抽查池
 * @method hookRefreshWorkListQueueSyncByParams(array $params) hookRefreshWorkListQueueSync
 * @method hookRefreshStreamCanReceiveStaffSyncByParams(array $params) hookRefreshStreamCanReceiveStaffSync
 */
class Hook {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Hook";

    /**
     * 监听创建NPS记录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function createHimoNps (string $orderNo, float $retoucherScore) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createHimoNps(["orderNo" => $orderNo, "retoucherScore" => $retoucherScore]);
    }

    /**
     * outStreamWaitReview
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function outStreamWaitReview (string $streamId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->outStreamWaitReview(["streamId" => $streamId]);
    }

    /**
     * outStreamWaitReviewed
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function outStreamWaitReviewed (string $streamId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->outStreamWaitReviewed(["streamId" => $streamId]);
    }

    /**
     * staffPositionUpdate
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function staffPositionUpdate (int $staffId, int $originalPositionId, int $positionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffPositionUpdate(["staffId" => $staffId, "originalPositionId" => $originalPositionId, "positionId" => $positionId]);
    }

    /**
     * hookQuotaEvent
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function hookQuotaEvent (string $item_name, int $object_id, string $type, int $cycle, float $value, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookQuotaEvent(array_merge($_params, ["item_name" => $item_name, "object_id" => $object_id, "type" => $type, "cycle" => $cycle, "value" => $value]));
    }

    /**
     * hookRefreshQueueSync
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function hookRefreshQueueSync (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookRefreshQueueSync(array_merge($_params, ["id" => $id]));
    }

    /**
     * hookStaffPassProducts
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookStaffPassProducts (int $staffId, int $trainingPlanId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookStaffPassProducts(["staffId" => $staffId, "trainingPlanId" => $trainingPlanId]);
    }

    /**
     * hookDelayReviewPass
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function hookDelayReviewPass (int $streamId, int $reviewId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookDelayReviewPass(array_merge($_params, ["streamId" => $streamId, "reviewId" => $reviewId]));
    }

    /**
     * hookPassConfigNotify
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookPassConfigNotify (int $planId, array $retoucherIds = [], bool $isDirectPass = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookPassConfigNotify(["planId" => $planId, "retoucherIds" => $retoucherIds, "isDirectPass" => $isDirectPass]);
    }

    /**
     * hookLearningPlanExamFail
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookLearningPlanExamFail (int $trainingPlanId, int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookLearningPlanExamFail(["trainingPlanId" => $trainingPlanId, "staffId" => $staffId]);
    }

    /**
     * hookOnlineWatcherTakeOrder
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookOnlineWatcherTakeOrder (string $outsideNo, int $watcherId, string $recordNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookOnlineWatcherTakeOrder(["outsideNo" => $outsideNo, "watcherId" => $watcherId, "recordNo" => $recordNo]);
    }

    /**
     * hookWatchRecordFinish
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookWatchRecordFinish (string $outsideNo, string $recordNo, array $photos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookWatchRecordFinish(["outsideNo" => $outsideNo, "recordNo" => $recordNo, "photos" => $photos]);
    }

    /**
     * hookWatchRecordClose
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookWatchRecordClose (string $outsideNo, string $recordNo, array $photos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookWatchRecordClose(["outsideNo" => $outsideNo, "recordNo" => $recordNo, "photos" => $photos]);
    }

    /**
     * hookWatchRecordConfirm
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookWatchRecordConfirm (array $streamNote) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookWatchRecordConfirm(["streamNote" => $streamNote]);
    }

    /**
     * hookFinishIntranetStream
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookFinishIntranetStream (int $streamId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookFinishIntranetStream(["streamId" => $streamId]);
    }

    /**
     * 超修激励配置更改状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookGoalRewardConfigChangeState (int $goalRewardConfigId, string $state) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookGoalRewardConfigChangeState(["goalRewardConfigId" => $goalRewardConfigId, "state" => $state]);
    }

    /**
     * hookStreamPassAddWaterMark
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function hookStreamPassAddWaterMark (string $stream_num, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookStreamPassAddWaterMark(array_merge($_params, ["stream_num" => $stream_num]));
    }

    /**
     * 修图师提交修图
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookSubmitPhoto (string $streamNum, string $submitTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookSubmitPhoto(["streamNum" => $streamNum, "submitTime" => $submitTime]);
    }

    /**
     * 流水审核通过-进入抽查池
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookStreamPassAddCheckPool (string $stream_num) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookStreamPassAddCheckPool(["stream_num" => $stream_num]);
    }

    /**
     * hookRefreshWorkListQueueSync
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookRefreshWorkListQueueSync (int $id, array $retoucherKey) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookRefreshWorkListQueueSync(["id" => $id, "retoucherKey" => $retoucherKey]);
    }

    /**
     * hookRefreshStreamCanReceiveStaffSync
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookRefreshStreamCanReceiveStaffSync (int $streamId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookRefreshStreamCanReceiveStaffSync(["streamId" => $streamId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}