<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-22 11:21:19
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class WeeklyQualityReport
 * @method getWeeklyQualityReportsByParams(array $params) 获取排行榜接口
 * @method autoCalcWeeklyQualityReportsByParams(array $params) 自动统计排行榜数据
 * @method theChartsByParams(array $params) 优秀张数、在线看片时岗位满意度、自修自看照片满意度排行榜
 */
class WeeklyQualityReport {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "WeeklyQualityReport";

    /**
     * 获取排行榜接口
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getWeeklyQualityReports (int $count = 10, bool $isRefreshCache = false, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWeeklyQualityReports(array_merge($_params, ["count" => $count, "isRefreshCache" => $isRefreshCache]));
    }

    /**
     * 自动统计排行榜数据
     * @return  bool
    */
    public static function autoCalcWeeklyQualityReports () {
        return RpcClass::getClass(self::$serviceName, self::$className)->autoCalcWeeklyQualityReports();
    }

    /**
     * 优秀张数、在线看片时岗位满意度、自修自看照片满意度排行榜
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\Common\TheChartDTO
    */
    public static function theCharts (\Mainto\Bridge\Structs\ProjectCloud\CMD\Common\TheChartCMD $theChartCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->theCharts($theChartCMD),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\Common\TheChartDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}