<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-12 18:22:40
 */
namespace Mainto\Bridge\Structs\ProjectCloud\Objects\Stream;

class SubmitFinalFilmParams {
    /**
     * @var  string
     * 流水号
     * validation: 
     */
    public string $streamNum;
    /**
     * @var  \Mainto\Bridge\Structs\ProjectCloud\Objects\Photo\VersionData[]
     * 照片版本信息
     * validation: 
     */
    public array $versionData;
    /**
     * @var  bool
     * 是否部分提交
     * validation: 
     */
    public bool $part = false;
    /**
     * @var  bool
     * 是否清空流水顾客满意片
     * validation: 
     */
    public bool $isClear = false;
    /**
     * @var  bool
     * 是否为最终成片
     * validation: 
     */
    public bool $isFinish = true;
    /**
     * @var  string
     * 看片类型 --- online OR offline
     * validation: 
     */
    public string $watchType = "offline";
    /**
     * @var  null|int
     * 看片师id
     * validation: 
     */
    public ?int $watcherId = null;

    public function __construct (string $streamNum = '', array $versionData = []) {
        if (!is_null($streamNum)) {
            $this->streamNum = $streamNum;
        }
        if (!is_null($versionData)) {
            $this->versionData = $versionData;
        }
    }

    public static function create(string $streamNum = '', array $versionData = []): self {
        return new self($streamNum, $versionData);
    }

    public function setStreamNum(string $streamNum): self {
        $this->streamNum = $streamNum;

        return $this;
    }

    public function setVersionData(array $versionData): self {
        $this->versionData = $versionData;

        return $this;
    }

    public function setPart(bool $part): self {
        $this->part = $part;

        return $this;
    }

    public function setIsClear(bool $isClear): self {
        $this->isClear = $isClear;

        return $this;
    }

    public function setIsFinish(bool $isFinish): self {
        $this->isFinish = $isFinish;

        return $this;
    }

    public function setWatchType(string $watchType): self {
        $this->watchType = $watchType;

        return $this;
    }

    public function setWatcherId(?int $watcherId): self {
        $this->watcherId = $watcherId;

        return $this;
    }
}