<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-14 15:01:06
 */
namespace Mainto\Bridge\Structs\ProjectCloud\CMD\GoalRewardConfig;

class AddGoalRewardConfigCMD {
    /**
     * @var  string
     * 标题
     * validation: max:15
     */
    public string $title;
    /**
     * @var  string
     * 开始时间, 开始时间要大于当前时间
     * validation: date_format:Y-m-d H:i|afterCurrDate
     */
    public string $startAt;
    /**
     * @var  string
     * 结束时间， 结束时间要大于开始时间
     * validation: date_format:Y-m-d H:i|after:startAt
     */
    public string $endAt;
    /**
     * @var  float
     * 奖励金额, 数值区间需要在0-99之间，保留两位小数
     * validation: numericalInterval
     */
    public float $value = 0;
    /**
     * @var  int[]
     * 产品ids
     * validation: 
     */
    public array $productIds;

    public function __construct (int $loginStaffId = 0, string $title = '', string $startAt = '', string $endAt = '', array $productIds = []) {
        if (!is_null($loginStaffId)) {
            $this->loginStaffId = $loginStaffId;
        }
        if (!is_null($title)) {
            $this->title = $title;
        }
        if (!is_null($startAt)) {
            $this->startAt = $startAt;
        }
        if (!is_null($endAt)) {
            $this->endAt = $endAt;
        }
        if (!is_null($productIds)) {
            $this->productIds = $productIds;
        }
    }

    public static function create(int $loginStaffId = 0, string $title = '', string $startAt = '', string $endAt = '', array $productIds = []): self {
        return new self($loginStaffId, $title, $startAt, $endAt, $productIds);
    }

    public function setTitle(string $title): self {
        $this->title = $title;

        return $this;
    }

    public function setStartAt(string $startAt): self {
        $this->startAt = $startAt;

        return $this;
    }

    public function setEndAt(string $endAt): self {
        $this->endAt = $endAt;

        return $this;
    }

    public function setValue(float $value): self {
        $this->value = $value;

        return $this;
    }

    public function setProductIds(array $productIds): self {
        $this->productIds = $productIds;

        return $this;
    }
}