<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-27 19:37:17
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Retoucher
 * @method joinQueueByParams(array $params) 进入队列
 * @method exitQueueByParams(array $params) 退出队列
 * @method haveReworkStreamByParams(array $params) 有流水退单[有就返回流水单号]
 * @method getStreamInfoByParams(array $params) 获取流水信息[沙漏时间会自减]--2.27
 * @method getRetouchStreamsByParams(array $params) 获取流水列表[待修，挂起]
 * @method getStreamQueueInfoByParams(array $params) 获取待修片队列信息
 * @method submitStreamByParams(array $params) 提交已修流水
 * @method hangStreamByParams(array $params) 挂起流水[仅能挂起缦图订单]
 * @method getRankInfoByParams(array $params) 获取个人修图等级信息
 * @method getPropsByParams(array $params) 获取道具
 * @method usePropByParams(array $params) 使用道具
 * @method getLittleBeeInfoByParams(array $params) 获取小蜜蜂奖励信息
 * @method getRetouchQuotaListByParams(array $params) 获取历史修图报告列表&lt;2.10更新接口&gt;
 * @method getSelfBuffInfoByParams(array $params) 获取个人buff信息
 * @method onlineByParams(array $params) 在线
 * @method offlineByParams(array $params) 离线
 * @method getOnlineStateByParams(array $params) 获取在线状态
 * @method getCheckPoolQuotaByParams(array $params) 获取组员云学院报告绩效&lt;2.10更新接口&gt;
 * @method getCheckPoolSubQuotaByParams(array $params) 获取组员云学院报告绩效&lt;2.24更新接口&gt;
 * @method getShowPicPoolSubQuotaByParams(array $params) 获取组员修修兽抽片报告绩效&lt;2.24更新接口&gt;
 * @method getAppealListByParams(array $params) 修图师自身申诉列表-v2.12
 * @method appealDetailByParams(array $params) 申诉详情-v2.12
 */
class Retoucher {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Retoucher";

    /**
     * 进入队列
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function joinQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->joinQueue();
    }

    /**
     * 退出队列
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function exitQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exitQueue();
    }

    /**
     * 有流水退单[有就返回流水单号]
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function haveReworkStream () {
        return RpcClass::getClass(self::$serviceName, self::$className)->haveReworkStream();
    }

    /**
     * 获取流水信息[沙漏时间会自减]--2.27
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStreamInfo (int $streamId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamInfo(array_merge($_params, ["streamId" => $streamId]));
    }

    /**
     * 获取流水列表[待修，挂起]
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getRetouchStreams (string $state, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchStreams(array_merge($_params, ["state" => $state]));
    }

    /**
     * 获取待修片队列信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStreamQueueInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamQueueInfo();
    }

    /**
     * 提交已修流水
     * @return  bool
    */
    public static function submitStream (\Mainto\Bridge\Structs\ProjectCloud\Objects\Stream\SubmitStream $submitStream) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitStream($submitStream);
    }

    /**
     * 挂起流水[仅能挂起缦图订单]
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function hangStream (int $streamId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hangStream(array_merge($_params, ["streamId" => $streamId]));
    }

    /**
     * 获取个人修图等级信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getRankInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRankInfo();
    }

    /**
     * 获取道具
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getProps () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProps();
    }

    /**
     * 使用道具
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function useProp (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useProp(array_merge($_params, ["id" => $id]));
    }

    /**
     * 获取小蜜蜂奖励信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getLittleBeeInfo (int $year, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLittleBeeInfo(array_merge($_params, ["year" => $year]));
    }

    /**
     * 获取历史修图报告列表&lt;2.10更新接口&gt;
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getRetouchQuotaList (string $streamNum = '', string $startAt = '', string $endAt = '', int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchQuotaList(array_merge($_params, ["streamNum" => $streamNum, "startAt" => $startAt, "endAt" => $endAt, "page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 获取个人buff信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getSelfBuffInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSelfBuffInfo();
    }

    /**
     * 在线
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function online () {
        return RpcClass::getClass(self::$serviceName, self::$className)->online();
    }

    /**
     * 离线
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function offline (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->offline(array_merge($_params, []));
    }

    /**
     * 获取在线状态
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getOnlineState () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOnlineState();
    }

    /**
     * 获取组员云学院报告绩效&lt;2.10更新接口&gt;
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getCheckPoolQuota (string $startAt, string $endAt, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCheckPoolQuota(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt]));
    }

    /**
     * 获取组员云学院报告绩效&lt;2.24更新接口&gt;
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getCheckPoolSubQuota (string $startAt, string $endAt, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCheckPoolSubQuota(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt]));
    }

    /**
     * 获取组员修修兽抽片报告绩效&lt;2.24更新接口&gt;
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getShowPicPoolSubQuota (string $startAt, string $endAt, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShowPicPoolSubQuota(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt]));
    }

    /**
     * 修图师自身申诉列表-v2.12
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getAppealList (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAppealList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 申诉详情-v2.12
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function appealDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->appealDetail(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}