<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-29 13:11:39
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class RetouchLeader
 * @method getTodayQuotaByParams(array $params) 获取今日指标[整组]
 * @method getGroupStaffTodayQuotaListByParams(array $params) 获取组员今日指标列表
 * @method getStaffQuotaInfoGroupByStaffByParams(array $params) 获取所有组员修图报告[分组]
 * @method getGroupStaffQuotaForCloudSchoolInfoByParams(array $params) 获取所有组员云学院修图报告统计
 * @method getGroupStaffQuotaForCloudSchoolInfoByStaffByParams(array $params) 获取所有组员云学院修图报告(柱状图) -----2.4
 * @method getGroupStaffScoreForCloudSchoolInfoByStaffByParams(array $params) 获取所有组员云学院修图评分(条状图) -----2.4
 * @method getReworkQuotaGroupByStaffByParams(array $params) 获取所有组员退单报告(条状图) -----2.10
 * @method getStaffRetouchListByParams(array $params) 获取组员修图记录
 * @method getStoreReturnQuotaByParams(array $params) 退单报告模块&lt;兼容云端组织架构调整&gt;
 * @method getCheckPoolQuotaByParams(array $params) 获取组员云学院报告绩效&lt;2.10更新接口&gt;
 * @method getCheckPoolSubQuotaByParams(array $params) 获取组员云学院报告绩效&lt;2.10更新接口&gt;
 * @method getCloudProblemReportByGroupByParams(array $params) 获取云学院问题统计(柱状图) ---2.10更新
 * @method getLittleBeeInfoByParams(array $params) [主管]获取小蜜蜂奖励信息－2.8
 * @method getCloudScoreByGroupByParams(array $params) 获取云学院修图组分数统计(柱状图) ---2.24更新
 * @method getCloudProblemByGroupByParams(array $params) 获取云学院修图组分数统计(柱状图) ---2.24更新
 * @method getShowPicScoreByGroupByParams(array $params) 获取修修兽修图组分数统计(柱状图) ---2.24更新
 * @method getShowPicProblemByGroupByParams(array $params) 获取修修兽修图组分数统计(柱状图) ---2.24更新
 */
class RetouchLeader {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "RetouchLeader";

    /**
     * 获取今日指标[整组]
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getTodayQuota () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTodayQuota();
    }

    /**
     * 获取组员今日指标列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getGroupStaffTodayQuotaList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupStaffTodayQuotaList();
    }

    /**
     * 获取所有组员修图报告[分组]
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStaffQuotaInfoGroupByStaff (int $groupId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffQuotaInfoGroupByStaff(array_merge($_params, ["groupId" => $groupId]));
    }

    /**
     * 获取所有组员云学院修图报告统计
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getGroupStaffQuotaForCloudSchoolInfo (int $groupId, string $staffId = '', array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupStaffQuotaForCloudSchoolInfo(array_merge($_params, ["groupId" => $groupId, "staffId" => $staffId]));
    }

    /**
     * 获取所有组员云学院修图报告(柱状图) -----2.4
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getGroupStaffQuotaForCloudSchoolInfoByStaff (array $staffIds = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupStaffQuotaForCloudSchoolInfoByStaff(array_merge($_params, ["staffIds" => $staffIds]));
    }

    /**
     * 获取所有组员云学院修图评分(条状图) -----2.4
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getGroupStaffScoreForCloudSchoolInfoByStaff (array $staffIds = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupStaffScoreForCloudSchoolInfoByStaff(array_merge($_params, ["staffIds" => $staffIds]));
    }

    /**
     * 获取所有组员退单报告(条状图) -----2.10
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getReworkQuotaGroupByStaff (string $startAt, string $endAt, int $groupId, array $staffIds = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReworkQuotaGroupByStaff(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt, "groupId" => $groupId, "staffIds" => $staffIds]));
    }

    /**
     * 获取组员修图记录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStaffRetouchList (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffRetouchList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 退单报告模块&lt;兼容云端组织架构调整&gt;
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStoreReturnQuota (string $startAt, string $endAt, array $retouchIds = [], int $groupId = 0, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreReturnQuota(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt, "retouchIds" => $retouchIds, "groupId" => $groupId]));
    }

    /**
     * 获取组员云学院报告绩效&lt;2.10更新接口&gt;
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getCheckPoolQuota (string $startAt, string $endAt, array $retoucherIds = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCheckPoolQuota(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt, "retoucherIds" => $retoucherIds]));
    }

    /**
     * 获取组员云学院报告绩效&lt;2.10更新接口&gt;
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getCheckPoolSubQuota (string $startAt, string $endAt, array $retoucherIds = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCheckPoolSubQuota(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt, "retoucherIds" => $retoucherIds]));
    }

    /**
     * 获取云学院问题统计(柱状图) ---2.10更新
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getCloudProblemReportByGroup (string $startAt, string $endAt, array $tagId = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudProblemReportByGroup(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt, "tagId" => $tagId]));
    }

    /**
     * [主管]获取小蜜蜂奖励信息－2.8
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getLittleBeeInfo (int $year, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLittleBeeInfo(array_merge($_params, ["year" => $year]));
    }

    /**
     * 获取云学院修图组分数统计(柱状图) ---2.24更新
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getCloudScoreByGroup (string $startAt, string $endAt, int $groupId, array $productIds = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudScoreByGroup(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt, "groupId" => $groupId, "productIds" => $productIds]));
    }

    /**
     * 获取云学院修图组分数统计(柱状图) ---2.24更新
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getCloudProblemByGroup (string $startAt, string $endAt, int $groupId, int $scoreTypeId = 0, array $tagIds = [], array $productIds = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudProblemByGroup(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt, "groupId" => $groupId, "scoreTypeId" => $scoreTypeId, "tagIds" => $tagIds, "productIds" => $productIds]));
    }

    /**
     * 获取修修兽修图组分数统计(柱状图) ---2.24更新
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getShowPicScoreByGroup (string $startAt, string $endAt, int $groupId, array $productIds = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShowPicScoreByGroup(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt, "groupId" => $groupId, "productIds" => $productIds]));
    }

    /**
     * 获取修修兽修图组分数统计(柱状图) ---2.24更新
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getShowPicProblemByGroup (string $startAt, string $endAt, int $groupId, int $scoreTypeId = 0, array $tagIds = [], array $productIds = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShowPicProblemByGroup(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt, "groupId" => $groupId, "scoreTypeId" => $scoreTypeId, "tagIds" => $tagIds, "productIds" => $productIds]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}