<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-30 09:57:00
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Common
 * @method getSelfInfoByParams(array $params) 获取当前个人信息
 * @method getStreamInfoByParams(array $params) 获取流水信息
 * @method getAllRetouchClassByParams(array $params) 获取全部修图类型
 * @method getAllProductByParams(array $params) 获取全部产品--2.24
 * @method getProductCategoryTreeByParams(array $params) 根据根节点id获取产品分类树--2.24
 * @method getAllRoleByParams(array $params) 获取全部角色组
 * @method getOrderInfoByParams(array $params) 获取订单信息
 * @method getRetouchOrgListByParams(array $params) 获取所有修图机构
 * @method getProductInfoByParams(array $params) 获取产品信息
 * @method getAuthorityByParams(array $params) 获取权限信息
 * @method getStaffListByParams(array $params) 获取伙伴列表
 * @method getWaitRetouchStreamQueueByParams(array $params) test获取队列
 * @method streamToRetoucherByParams(array $params) test指定修片师
 * @method streamToReviewerByParams(array $params) test指定审核人
 * @method delWaitRetoucherQueueByParams(array $params) test清空队列
 * @method staffExitStreamByParams(array $params) 修片解绑-test-辅助
 * @method rePushStreamQueueByParams(array $params) 重推修片&amp;审核队列
 * @method pushRetoucherByParams(array $params) 人员推到队列
 * @method pushReviewerByParams(array $params) 人员推到审核队列
 * @method pullRetoucherByParams(array $params) 人员推出修片队列
 * @method pullReviewerByParams(array $params) 人员推出审核队列
 * @method getSelfStaffsByParams(array $params) 根据组id获取自己所有组员
 * @method getCloudRetoucherByParams(array $params) 获取云端所有修图师
 * @method getReviewerByParams(array $params) 获取所有审核人
 * @method getRetoucherGroupByParams(array $params) 获取所有修图组
 * @method getPhotographerOrgByParams(array $params) 获取摄影机构
 * @method getRetoucherOrgByParams(array $params) 获取修片机构
 * @method getRetoucherOrgWithProductByParams(array $params) 获取修片机构及可接产品
 * @method initRandomSequenceByParams(array $params) test初始化当日随机数
 * @method streamTimeRpcLogByParams(array $params) 记录流水时间点
 * @method getCacheCountByParams(array $params) 获取缓存
 * @method incrCacheCountByParams(array $params) 递增缓存
 * @method getWebSocketSignatureByParams(array $params) 获取ws票据
 * @method webSocketByParams(array $params) webSocket入口
 * @method getRetoucherLeadersByParams(array $params) 获取修片主管和运营主管
 * @method getOnlineStateByParams(array $params) 获取全局在线状态
 * @method wsOfflineByParams(array $params) wsOffline
 * @method getPhotoProblemTagSetsByParams(array $params) 获取摄影化妆问题标签
 * @method addVersionInfoByParams(array $params) 添加版本更新信息
 * @method updateVersionInfoByParams(array $params) 修改版本更新信息
 * @method getVersionInfoForPaginateByParams(array $params) 获取版本更新信息分页
 * @method getAllVersionNumByParams(array $params) 过去所有版本号
 * @method getAnniversaryInfoByParams(array $params) 获取周年庆个人信息
 * @method getBackColorsByParams(array $params) 获取修图底色列表--2.27
 * @method getRegionRetoucherTreeByParams(array $params) 获取修图师按区域分组--2.12.25
 * @method getMentorsByParams(array $params) 获取所有区域导师--2.12.25
 * @method getMarkingMentorsByParams(array $params) 获取所有阅卷导师--2.12.25
 * @method getStaffPassRecordsByParams(array $params) 获取单个伙伴通关记录
 * @method retouchPhotoRankingByParams(array $params) 获取修图排行榜
 * @method getAllProductsAISettingByParams(array $params) 获取全部产品的AI修图配置
 * @method getProductsAISettingByIdByParams(array $params) 根据产品id获取AI修图配置
 * @method getStaffByPageByParams(array $params) 获取所有云端账号-带分页
 * @method getSupervisorOnDutyAndDingStaffUidByParams(array $params) 获取值班主管, 带钉钉内部uid
 * @method getAllStoreListByParams(array $params) 获取所有门店信息
 */
class Common {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Common";

    /**
     * 获取当前个人信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getSelfInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSelfInfo();
    }

    /**
     * 获取流水信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStreamInfo (int $streamId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamInfo(["streamId" => $streamId]);
    }

    /**
     * 获取全部修图类型
     * @return  array
    */
    public static function getAllRetouchClass () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllRetouchClass();
    }

    /**
     * 获取全部产品--2.24
     * @return  mixed
    */
    public static function getAllProduct () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProduct();
    }

    /**
     * 根据根节点id获取产品分类树--2.24
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductCategoryTree (int $rootId, bool $withProduct = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCategoryTree(["rootId" => $rootId, "withProduct" => $withProduct]);
    }

    /**
     * 获取全部角色组
     * @return  array
    */
    public static function getAllRole () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllRole();
    }

    /**
     * 获取订单信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderInfo (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderInfo(["orderId" => $orderId]);
    }

    /**
     * 获取所有修图机构
     * @return  array
    */
    public static function getRetouchOrgList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchOrgList();
    }

    /**
     * 获取产品信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductInfo (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductInfo(["productId" => $productId]);
    }

    /**
     * 获取权限信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getAuthority () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAuthority();
    }

    /**
     * 获取伙伴列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStaffList (bool $needDelete = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffList(["needDelete" => $needDelete]);
    }

    /**
     * test获取队列
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getWaitRetouchStreamQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWaitRetouchStreamQueue();
    }

    /**
     * test指定修片师
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function streamToRetoucher (int $staffId, int $streamId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->streamToRetoucher(array_merge($_params, ["staffId" => $staffId, "streamId" => $streamId]));
    }

    /**
     * test指定审核人
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function streamToReviewer (int $staffId, int $streamId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->streamToReviewer(array_merge($_params, ["staffId" => $staffId, "streamId" => $streamId]));
    }

    /**
     * test清空队列
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function delWaitRetoucherQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->delWaitRetoucherQueue();
    }

    /**
     * 修片解绑-test-辅助
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function staffExitStream (string $streamNum, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->staffExitStream(array_merge($_params, ["streamNum" => $streamNum]));
    }

    /**
     * 重推修片&amp;审核队列
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function rePushStreamQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->rePushStreamQueue();
    }

    /**
     * 人员推到队列
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function pushRetoucher (int $staffId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pushRetoucher(array_merge($_params, ["staffId" => $staffId]));
    }

    /**
     * 人员推到审核队列
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function pushReviewer (int $staffId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pushReviewer(array_merge($_params, ["staffId" => $staffId]));
    }

    /**
     * 人员推出修片队列
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function pullRetoucher (int $staffId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pullRetoucher(array_merge($_params, ["staffId" => $staffId]));
    }

    /**
     * 人员推出审核队列
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function pullReviewer (int $staffId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->pullReviewer(array_merge($_params, ["staffId" => $staffId]));
    }

    /**
     * 根据组id获取自己所有组员
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getSelfStaffs (int $groupId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSelfStaffs(array_merge($_params, ["groupId" => $groupId]));
    }

    /**
     * 获取云端所有修图师
     * @return  mixed
    */
    public static function getCloudRetoucher () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudRetoucher();
    }

    /**
     * 获取所有审核人
     * @return  mixed
    */
    public static function getReviewer () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReviewer();
    }

    /**
     * 获取所有修图组
     * @return  mixed
    */
    public static function getRetoucherGroup () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetoucherGroup();
    }

    /**
     * 获取摄影机构
     * @return  mixed
    */
    public static function getPhotographerOrg () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotographerOrg();
    }

    /**
     * 获取修片机构
     * @return  mixed
    */
    public static function getRetoucherOrg () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetoucherOrg();
    }

    /**
     * 获取修片机构及可接产品
     * @return  mixed
    */
    public static function getRetoucherOrgWithProduct () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetoucherOrgWithProduct();
    }

    /**
     * test初始化当日随机数
     * @return  mixed
    */
    public static function initRandomSequence () {
        return RpcClass::getClass(self::$serviceName, self::$className)->initRandomSequence();
    }

    /**
     * 记录流水时间点
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function streamTimeRpcLog (int $streamId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->streamTimeRpcLog(array_merge($_params, ["streamId" => $streamId]));
    }

    /**
     * 获取缓存
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getCacheCount (string $cacheKey, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCacheCount(array_merge($_params, ["cacheKey" => $cacheKey]));
    }

    /**
     * 递增缓存
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function incrCacheCount (string $cacheKey, int $increment = 1, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->incrCacheCount(array_merge($_params, ["cacheKey" => $cacheKey, "increment" => $increment]));
    }

    /**
     * 获取ws票据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getWebSocketSignature () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWebSocketSignature();
    }

    /**
     * webSocket入口
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function webSocket () {
        return RpcClass::getClass(self::$serviceName, self::$className)->webSocket();
    }

    /**
     * 获取修片主管和运营主管
     * @return  array
    */
    public static function getRetoucherLeaders () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetoucherLeaders();
    }

    /**
     * 获取全局在线状态
     * @return  array
    */
    public static function getOnlineState () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOnlineState();
    }

    /**
     * wsOffline
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function wsOffline (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->wsOffline(["staffId" => $staffId]);
    }

    /**
     * 获取摄影化妆问题标签
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getPhotoProblemTagSets (string $about = null, bool $withDeleted = false, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoProblemTagSets(array_merge($_params, ["about" => $about, "withDeleted" => $withDeleted]));
    }

    /**
     * 添加版本更新信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function addVersionInfo (string $versionNum, string $info, string $versionTime, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addVersionInfo(array_merge($_params, ["versionNum" => $versionNum, "info" => $info, "versionTime" => $versionTime]));
    }

    /**
     * 修改版本更新信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function updateVersionInfo (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateVersionInfo(array_merge($_params, ["id" => $id]));
    }

    /**
     * 获取版本更新信息分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getVersionInfoForPaginate (string $versionNum = '', int $page = 0, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getVersionInfoForPaginate(["versionNum" => $versionNum, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 过去所有版本号
     * @return  array
    */
    public static function getAllVersionNum () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllVersionNum();
    }

    /**
     * 获取周年庆个人信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getAnniversaryInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAnniversaryInfo();
    }

    /**
     * 获取修图底色列表--2.27
     * @return  array
    */
    public static function getBackColors () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBackColors();
    }

    /**
     * 获取修图师按区域分组--2.12.25
     * @return  mixed
    */
    public static function getRegionRetoucherTree () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRegionRetoucherTree();
    }

    /**
     * 获取所有区域导师--2.12.25
     * @return  mixed
    */
    public static function getMentors () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMentors();
    }

    /**
     * 获取所有阅卷导师--2.12.25
     * @return  mixed
    */
    public static function getMarkingMentors () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMarkingMentors();
    }

    /**
     * 获取单个伙伴通关记录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStaffPassRecords (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffPassRecords(["staffId" => $staffId]);
    }

    /**
     * 获取修图排行榜
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function retouchPhotoRanking (string $startAt, string $endAt, int $limit) {
        return RpcClass::getClass(self::$serviceName, self::$className)->retouchPhotoRanking(["startAt" => $startAt, "endAt" => $endAt, "limit" => $limit]);
    }

    /**
     * 获取全部产品的AI修图配置
     * @return  mixed
    */
    public static function getAllProductsAISetting () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllProductsAISetting();
    }

    /**
     * 根据产品id获取AI修图配置
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getProductsAISettingById (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsAISettingById(["productId" => $productId]);
    }

    /**
     * 获取所有云端账号-带分页
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\StaffByPageDTO
    */
    public static function getStaffByPage (string $nameOrNickname = null, int $page = 1, int $pageSize = 20) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStaffByPage(["nameOrNickname" => $nameOrNickname, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\StaffByPageDTO"
        );
    }

    /**
     * 获取值班主管, 带钉钉内部uid
     * @return  array
    */
    public static function getSupervisorOnDutyAndDingStaffUid () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSupervisorOnDutyAndDingStaffUid(),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\SupervisorOnDuty\SupervisorOnDutyDTOStaffDingUid[]"
        );
    }

    /**
     * 获取所有门店信息
     * @return  array
    */
    public static function getAllStoreList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAllStoreList(),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\StoreDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}