<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-23 17:16:52
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\Trainning;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class TrainPlan
 * @method createTrainPlanByParams(array $params) 创建星耀计划
 * @method editTrainPlanByParams(array $params) 修改星耀计划配置
 * @method createExamConfigByParams(array $params) 考核配置
 * @method editExamConfigByParams(array $params) 修改考核配置
 * @method delExamConfigByParams(array $params) 删除考核配置
 * @method createPassConfigByParams(array $params) 通关配置
 * @method getTrainPlanDetailByParams(array $params) 获取星耀计划配置详情
 * @method getTrainPlanListByParams(array $params) 星耀培训计划列表
 * @method saveTrainPlanDraftByParams(array $params) 草稿存储
 * @method getTrainPlanDraftByParams(array $params) 创建星耀培训计划--获取草稿
 * @method delTrainPlanByParams(array $params) 创建星耀培训计划--删除
 * @method planDataAggByParams(array $params) 星耀计划 -- 数据面板
 * @method checkJoinStaffByParams(array $params) 校验培训伙伴
 */
class TrainPlan {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Trainning\\TrainPlan";

    /**
     * 创建星耀计划
     * @return  int
    */
    public static function createTrainPlan (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\TrainPlanConfig\CreateTrainPlan $createTrainPlan) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createTrainPlan($createTrainPlan);
    }

    /**
     * 修改星耀计划配置
     * @return  int
    */
    public static function editTrainPlan (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\TrainPlanConfig\EditTrainPlan $editTrainPlan) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editTrainPlan($editTrainPlan);
    }

    /**
     * 考核配置
     * @return  int
    */
    public static function createExamConfig (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\ExamConfig\CreateExamConfig $createExamConfig) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createExamConfig($createExamConfig);
    }

    /**
     * 修改考核配置
     * @return  int
    */
    public static function editExamConfig (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\ExamConfig\EditExamConfig $editExamConfig) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editExamConfig($editExamConfig);
    }

    /**
     * 删除考核配置
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function delExamConfig (int $examConfigId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delExamConfig(array_merge($_params, ["examConfigId" => $examConfigId]));
    }

    /**
     * 通关配置
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function createPassConfig (int $planId, bool $isEdit = false, array $retoucherIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPassConfig(array_merge($_params, ["planId" => $planId, "isEdit" => $isEdit, "retoucherIds" => $retoucherIds]));
    }

    /**
     * 获取星耀计划配置详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getTrainPlanDetail (int $planId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTrainPlanDetail(["planId" => $planId]);
    }

    /**
     * 星耀培训计划列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getTrainPlanList (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTrainPlanList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 草稿存储
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function saveTrainPlanDraft (array $contentArr, string $step, int $planId = null, string $draftUuid, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveTrainPlanDraft(array_merge($_params, ["contentArr" => $contentArr, "step" => $step, "planId" => $planId, "draftUuid" => $draftUuid]));
    }

    /**
     * 创建星耀培训计划--获取草稿
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getTrainPlanDraft (int $planId = null, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTrainPlanDraft(array_merge($_params, ["planId" => $planId]));
    }

    /**
     * 创建星耀培训计划--删除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delTrainPlan (int $planId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delTrainPlan(["planId" => $planId]);
    }

    /**
     * 星耀计划 -- 数据面板
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function planDataAgg (int $planId, array $staffIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->planDataAgg(["planId" => $planId, "staffIds" => $staffIds]);
    }

    /**
     * 校验培训伙伴
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\TrainPlan\CheckJoinStaff\CheckJoinStaffResultDTO
    */
    public static function checkJoinStaff (array $staff) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->checkJoinStaff(["staff" => $staff]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\TrainPlan\CheckJoinStaff\CheckJoinStaffResultDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}