<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-22 15:35:38
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PhotoManager
 * @method getSignatureByParams(array $params) 获取又拍云上传凭证
 * @method getUploadTokenByParams(array $params) 获取七牛云上传token
 * @method getHostByParams(array $params) 返回host
 * @method createPhotoVersionByParams(array $params) 覆盖上传
 * @method checkUploadIntranetPhotoByParams(array $params) 检查本地上传服务是否可用
 */
class PhotoManager {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "PhotoManager";

    /**
     * 获取又拍云上传凭证
     * @return  mixed
    */
    public static function getSignature () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSignature();
    }

    /**
     * 获取七牛云上传token
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getUploadToken () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUploadToken();
    }

    /**
     * 返回host
     * @return  mixed
    */
    public static function getHost () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHost();
    }

    /**
     * 覆盖上传
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function createPhotoVersion (string $version, string $path, int $photoId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPhotoVersion(["version" => $version, "path" => $path, "photoId" => $photoId]);
    }

    /**
     * 检查本地上传服务是否可用
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function checkUploadIntranetPhoto () {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUploadIntranetPhoto();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}