<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-10-29 23:01:57
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\Trainning;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class LearnPlan
 * @method getLearnPlanListByParams(array $params) 学习列表
 * @method getLearnPlanTotalByParams(array $params) 学习计划人数
 * @method getLearnPlanPlanDetailByParams(array $params) 学习计划详情
 * @method urgedCompleteByParams(array $params) 催促完成
 * @method urgedMarkingByParams(array $params) 催促阅卷
 * @method learningPlanMarkPaperByParams(array $params) 阅卷
 * @method getPaperDetailByParams(array $params) 获取考核记录与试卷
 * @method startPaperByParams(array $params) 开始一张试卷
 * @method startLearningPlanExamByParams(array $params) 开始学习计划考核
 * @method submitLearningPlanPaperByParams(array $params) 学习计划提交试卷
 * @method learningPlanStartByParams(array $params) 开始学习计划
 * @method learningStateExportByPlanIdByParams(array $params) 根据计划id导出伙伴培训状态
 * @method learningPlanStaffStateByParams(array $params) 获取伙伴培训状态
 */
class LearnPlan {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Trainning\\LearnPlan";

    /**
     * 学习列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getLearnPlanList (int $page = 1, int $pageSize = 10, int $trainingPlanId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLearnPlanList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize, "trainingPlanId" => $trainingPlanId]));
    }

    /**
     * 学习计划人数
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getLearnPlanTotal (int $trainingPlanId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLearnPlanTotal(["trainingPlanId" => $trainingPlanId]);
    }

    /**
     * 学习计划详情
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getLearnPlanPlanDetail (int $learningPlanId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLearnPlanPlanDetail(array_merge($_params, ["learningPlanId" => $learningPlanId]));
    }

    /**
     * 催促完成
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function urgedComplete (int $planId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->urgedComplete(array_merge($_params, ["planId" => $planId]));
    }

    /**
     * 催促阅卷
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function urgedMarking (int $planId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->urgedMarking(array_merge($_params, ["planId" => $planId]));
    }

    /**
     * 阅卷
     * @return  mixed
    */
    public static function learningPlanMarkPaper (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\MarkPaper\MarkPaper $markPaper) {
        return RpcClass::getClass(self::$serviceName, self::$className)->learningPlanMarkPaper($markPaper);
    }

    /**
     * 获取考核记录与试卷
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getPaperDetail (string $paperId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPaperDetail(["paperId" => $paperId]);
    }

    /**
     * 开始一张试卷
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function startPaper (string $paperId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->startPaper(["paperId" => $paperId]);
    }

    /**
     * 开始学习计划考核
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function startLearningPlanExam (int $learningPlanId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->startLearningPlanExam(["learningPlanId" => $learningPlanId]);
    }

    /**
     * 学习计划提交试卷
     * @return  mixed
    */
    public static function submitLearningPlanPaper (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\SubmitLearningPlanPaper\SubmitLearningPlanPaper $submitLearningPlanPaper) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitLearningPlanPaper($submitLearningPlanPaper);
    }

    /**
     * 开始学习计划
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function learningPlanStart (int $learningPlanId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->learningPlanStart(["learningPlanId" => $learningPlanId]);
    }

    /**
     * 根据计划id导出伙伴培训状态
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  string
    */
    public static function learningStateExportByPlanId (int $trainingPlanId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->learningStateExportByPlanId(array_merge($_params, ["trainingPlanId" => $trainingPlanId]));
    }

    /**
     * 获取伙伴培训状态
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function learningPlanStaffState (int $trainingPlanId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->learningPlanStaffState(["trainingPlanId" => $trainingPlanId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}