<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-07 13:15:02
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class AssignOrderConfig
 * @method getAssignOrderConfigPageListByParams(array $params) 获取指派配置分页列表
 * @method getAssignOrderConfigDetailByParams(array $params) 获取指派配置详情
 * @method addAssignOrderConfigByParams(array $params) 创建指派配置
 * @method editAssignOrderConfigByParams(array $params) 更新指派配置
 * @method delAssignOrderConfigByParams(array $params) 删除指派配置
 * @method addEditAssignGroupByParams(array $params) 配置自动指派商品组
 * @method delAssignGroupByParams(array $params) 删除自动指派商品组
 * @method listAssignGroupByParams(array $params) 自动指派商品组列表
 * @method assignGroupDetailByParams(array $params) 自动指派商品组详情
 * @method assignGroupProductListByParams(array $params) 根据自动指派产品组ID获取产品列表
 */
class AssignOrderConfig {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "AssignOrderConfig";

    /**
     * 获取指派配置分页列表
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\AssignOrderConfig\GetAssignOrderConfigPageListDTO
    */
    public static function getAssignOrderConfigPageList (?\Mainto\Bridge\Structs\ProjectCloud\CMD\AssignOrderConfig\GetAssignOrderConfigPageListCMD $getAssignOrderConfigPageListCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAssignOrderConfigPageList($getAssignOrderConfigPageListCMD),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\AssignOrderConfig\GetAssignOrderConfigPageListDTO"
        );
    }

    /**
     * 获取指派配置详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\AssignOrderConfig\AssignOrderConfigDetailDTO
    */
    public static function getAssignOrderConfigDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAssignOrderConfigDetail(["id" => $id]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\AssignOrderConfig\AssignOrderConfigDetailDTO"
        );
    }

    /**
     * 创建指派配置
     * @return  bool
    */
    public static function addAssignOrderConfig (\Mainto\Bridge\Structs\ProjectCloud\CMD\AssignOrderConfig\AddAssignOrderConfigCMD $addAssignOrderConfigCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addAssignOrderConfig($addAssignOrderConfigCMD);
    }

    /**
     * 更新指派配置
     * @return  bool
    */
    public static function editAssignOrderConfig (\Mainto\Bridge\Structs\ProjectCloud\CMD\AssignOrderConfig\EditAssignOrderConfigCMD $editAssignOrderConfigCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editAssignOrderConfig($editAssignOrderConfigCMD);
    }

    /**
     * 删除指派配置
     * @return  bool
    */
    public static function delAssignOrderConfig (\Mainto\Bridge\Structs\ProjectCloud\CMD\AssignOrderConfig\DelAssignOrderConfigCMD $delAssignOrderConfigCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delAssignOrderConfig($delAssignOrderConfigCMD);
    }

    /**
     * 配置自动指派商品组
     * @return  bool
    */
    public static function addEditAssignGroup (\Mainto\Bridge\Structs\ProjectCloud\CMD\AssignGroup\AddEditAssignGroupCMD $addEditAssignGroupCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addEditAssignGroup($addEditAssignGroupCMD);
    }

    /**
     * 删除自动指派商品组
     * @return  bool
    */
    public static function delAssignGroup (\Mainto\Bridge\Structs\ProjectCloud\CMD\AssignGroup\DelEditAssignGroupCMD $delEditAssignGroupCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delAssignGroup($delEditAssignGroupCMD);
    }

    /**
     * 自动指派商品组列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\AssignGroup\AssignGroupListDTO
    */
    public static function listAssignGroup (int $page = 1, int $pageSize = 10, bool $isShowProduct = false, bool $isAll = false) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->listAssignGroup(["page" => $page, "pageSize" => $pageSize, "isShowProduct" => $isShowProduct, "isAll" => $isAll]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\AssignGroup\AssignGroupListDTO"
        );
    }

    /**
     * 自动指派商品组详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\AssignGroup\AssignGroupDetailDTO
    */
    public static function assignGroupDetail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->assignGroupDetail(["id" => $id]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\AssignGroup\AssignGroupDetailDTO"
        );
    }

    /**
     * 根据自动指派产品组ID获取产品列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function assignGroupProductList (array $assignGroupIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->assignGroupProductList(["assignGroupIds" => $assignGroupIds]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\AssignGroup\AssignGroupProductDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}