<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-03 17:20:31
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Config
 * @method getHourGlassListByParams(array $params) 获取沙漏列表[产品沙漏]
 * @method getBaseHourGlassSettingByParams(array $params) 获取基础沙漏列表
 * @method getHourGlassInfoByParams(array $params) 获取沙漏详情
 * @method enableHourGlassGlobalStateByParams(array $params) 开启全局沙漏状态
 * @method disableHourGlassGlobalStateByParams(array $params) 关闭全局沙漏状态
 * @method addHourGlassByParams(array $params) 添加沙漏
 * @method editHourGlassByParams(array $params) 编辑沙漏
 * @method deleteHourGlassByParams(array $params) 删除沙漏
 * @method addCardByParams(array $params) 添加伙伴卡片配置
 * @method closeCardByParams(array $params) 关闭卡片配置
 * @method deleteCardByParams(array $params) 删除卡片配置
 * @method getStaffCardListByParams(array $params) 获取已配置卡片列表
 * @method getImpulseListByParams(array $params) 获取已配置冲量奖励列表
 * @method addImpulseByParams(array $params) 新增冲量奖励
 * @method addImpulseSettingItemByParams(array $params) 新增冲量奖励配置
 * @method delImpulseSettingItemByParams(array $params) 删除冲量奖励配置
 * @method getImpulseSettingItemListByParams(array $params) 获取冲量奖励配置项列表
 * @method getImpulseInfoByParams(array $params) 获取冲量奖励详情
 * @method deleteImpulseByParams(array $params) 删除冲量奖励
 * @method disableImpulseByParams(array $params) 关闭冲量奖励
 * @method getGreenChannelInfoByParams(array $params) 获取绿色通道人员
 * @method saveGreenChannelInfoByParams(array $params) 更新绿色通道人员
 * @method getSuggestWorkloadByParams(array $params) 获取建议工作量
 * @method saveSuggestWorkloadByParams(array $params) 保存建议工作量
 * @method addTimeIntervalRewardConfigByParams(array $params) 创建时段配置
 * @method getTimeIntervalRewardConfigByParams(array $params) 获取时段配置详情
 * @method stopTimeIntervalRewardConfigByParams(array $params) 奖励配置停止
 * @method getTimeIntervalRewardConfigListByParams(array $params) 获取时段配置列表
 * @method getLevelConfigListByParams(array $params) 获取升降级配置列表
 * @method setLevelConfigByParams(array $params) 升降级规则配置
 */
class Config {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Config";

    /**
     * 获取沙漏列表[产品沙漏]
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getHourGlassList (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHourGlassList(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 获取基础沙漏列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getBaseHourGlassSetting (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBaseHourGlassSetting(["page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * 获取沙漏详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getHourGlassInfo (int $configId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHourGlassInfo(["configId" => $configId]);
    }

    /**
     * 开启全局沙漏状态
     * @return  mixed
    */
    public static function enableHourGlassGlobalState () {
        return RpcClass::getClass(self::$serviceName, self::$className)->enableHourGlassGlobalState();
    }

    /**
     * 关闭全局沙漏状态
     * @return  mixed
    */
    public static function disableHourGlassGlobalState () {
        return RpcClass::getClass(self::$serviceName, self::$className)->disableHourGlassGlobalState();
    }

    /**
     * 添加沙漏
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addHourGlass (array $staffRanges, int $baseTime, int $superimposedTime, int $standardTime = 0, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addHourGlass(array_merge($_params, ["staffRanges" => $staffRanges, "baseTime" => $baseTime, "superimposedTime" => $superimposedTime, "standardTime" => $standardTime]));
    }

    /**
     * 编辑沙漏
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function editHourGlass (int $configId, string $retouchStandard, array $productIds, array $staffRanges, int $baseTime, int $superimposedTime, int $standardTime = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editHourGlass(["configId" => $configId, "retouchStandard" => $retouchStandard, "productIds" => $productIds, "staffRanges" => $staffRanges, "baseTime" => $baseTime, "superimposedTime" => $superimposedTime, "standardTime" => $standardTime]);
    }

    /**
     * 删除沙漏
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function deleteHourGlass (int $configId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteHourGlass(["configId" => $configId]);
    }

    /**
     * 添加伙伴卡片配置
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addCard (string $type, float $multiple, array $staffIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addCard(array_merge($_params, ["type" => $type, "multiple" => $multiple, "staffIds" => $staffIds]));
    }

    /**
     * 关闭卡片配置
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function closeCard (int $staffCardId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeCard(array_merge($_params, ["staffCardId" => $staffCardId]));
    }

    /**
     * 删除卡片配置
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function deleteCard (int $staffCardId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteCard(array_merge($_params, ["staffCardId" => $staffCardId]));
    }

    /**
     * 获取已配置卡片列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStaffCardList (int $page, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffCardList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 获取已配置冲量奖励列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getImpulseList (int $page = 1, int $pageSize = 20, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getImpulseList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 新增冲量奖励
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addImpulse (string $title, array $settingItemIds, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addImpulse(array_merge($_params, ["title" => $title, "settingItemIds" => $settingItemIds]));
    }

    /**
     * 新增冲量奖励配置
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addImpulseSettingItem (float $reachExp, string $type, float $reward, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addImpulseSettingItem(array_merge($_params, ["reachExp" => $reachExp, "type" => $type, "reward" => $reward]));
    }

    /**
     * 删除冲量奖励配置
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delImpulseSettingItem (int $itemId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delImpulseSettingItem(["itemId" => $itemId]);
    }

    /**
     * 获取冲量奖励配置项列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getImpulseSettingItemList (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getImpulseSettingItemList(array_merge($_params, []));
    }

    /**
     * 获取冲量奖励详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getImpulseInfo (int $impulseId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getImpulseInfo(["impulseId" => $impulseId]);
    }

    /**
     * 删除冲量奖励
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function deleteImpulse (int $impulseId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteImpulse(["impulseId" => $impulseId]);
    }

    /**
     * 关闭冲量奖励
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function disableImpulse (int $impulseId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->disableImpulse(["impulseId" => $impulseId]);
    }

    /**
     * 获取绿色通道人员
     * @return  mixed
    */
    public static function getGreenChannelInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGreenChannelInfo();
    }

    /**
     * 更新绿色通道人员
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function saveGreenChannelInfo (array $staffIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveGreenChannelInfo(["staffIds" => $staffIds]);
    }

    /**
     * 获取建议工作量
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSuggestWorkload (int $retouchClassId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSuggestWorkload(["retouchClassId" => $retouchClassId]);
    }

    /**
     * 保存建议工作量
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function saveSuggestWorkload (int $retouchClassId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveSuggestWorkload(array_merge($_params, ["retouchClassId" => $retouchClassId]));
    }

    /**
     * 创建时段配置
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addTimeIntervalRewardConfig (string $type, string $title, array $staffIds, string $beginAt, string $endAt, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addTimeIntervalRewardConfig(array_merge($_params, ["type" => $type, "title" => $title, "staffIds" => $staffIds, "beginAt" => $beginAt, "endAt" => $endAt]));
    }

    /**
     * 获取时段配置详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getTimeIntervalRewardConfig (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTimeIntervalRewardConfig(["id" => $id]);
    }

    /**
     * 奖励配置停止
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function stopTimeIntervalRewardConfig (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stopTimeIntervalRewardConfig(["id" => $id]);
    }

    /**
     * 获取时段配置列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getTimeIntervalRewardConfigList (int $page = 1, int $pageSize = 10, array $conds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTimeIntervalRewardConfigList(["page" => $page, "pageSize" => $pageSize, "conds" => $conds]);
    }

    /**
     * 获取升降级配置列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getLevelConfigList (string $type = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLevelConfigList(["type" => $type]);
    }

    /**
     * 升降级规则配置
     * @return  bool
    */
    public static function setLevelConfig (\Mainto\Bridge\Structs\ProjectCloud\CMD\SetLevelConfigCMD $setLevelConfigCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setLevelConfig($setLevelConfigCMD);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}