<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-06 16:01:36
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class CheckPool
 * @method takeItemByParams(array $params) 云学院抽片
 * @method getHaveSpotCheckResultByParams(array $params) 获取是否有未评分的抽片
 * @method getSpotCheckResultByParams(array $params) 获取抽片结果--2.27
 * @method getSearchHistoryByParams(array $params) 获取抽片历史记录--2.27
 * @method getStatisticsByParams(array $params) 获取今日抽片指标
 * @method commitHistoryByParams(array $params) 云学院提交评价
 * @method updateCommitHistoryByParams(array $params) 更新云学院修改提交评价----2.6更新
 * @method getUpdateCommitHistoryLogByParams(array $params) 获取更新云学院修改提交评价记录----2.6更新
 * @method fixCheckPoolConfigByParams(array $params) 抽片池配置修改-test
 * @method addScoreTypeByParams(array $params) 添加云学院类别 ---v2.24
 * @method editScoreTypeByParams(array $params) 修改云学院类别 ---v2.24
 * @method getScoreConfigListByParams(array $params) 获取云学院评分配置列表 ---v2.24
 * @method addScoreConfigByParams(array $params) 添加云学院评分配置---v2.24
 * @method editScoreConfigByParams(array $params) 修改云学院评分配置---v2.24
 * @method delScoreConfigByParams(array $params) 删除云学院评分配置---v2.24
 * @method getCloudScoreByStaffIdsByParams(array $params) 获取云学院修图师分数统计(柱状图)
 * @method getCloudScoreByGroupByParams(array $params) 获取云学院修图组分数统计(柱状图) ---2.24更新
 * @method getCloudProblemByGroupByParams(array $params) 获取云学院修图组分数统计(柱状图) ---2.24更新
 * @method emptyCheckPoolByStaffIdByParams(array $params) 清空云学院记录 ---2.8更新
 * @method getTakeStaffListByParams(array $params) 获取评分人列表 ---2.8更新
 * @method getOldScoreConfigListByParams(array $params) 获取老评分列表 ---2.8更新
 * @method changeItemByParams(array $params) 云学院换一单
 * @method skipStaffByParams(array $params) 云学院-跳过伙伴
 * @method hasChangeItemByParams(array $params) 云学院检查换一单
 * @method setScoreScaleByParams(array $params) 设置评分档位
 * @method getScoreScaleByParams(array $params) 获取评分档位
 * @method isCheckPoolExperimentByParams(array $params) 抽片试点
 */
class CheckPool {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "CheckPool\\CheckPool";

    /**
     * 云学院抽片
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function takeItem (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->takeItem(array_merge($_params, []));
    }

    /**
     * 获取是否有未评分的抽片
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getHaveSpotCheckResult () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHaveSpotCheckResult();
    }

    /**
     * 获取抽片结果--2.27
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getSpotCheckResult (string $uuid, int $skip = 0, int $limit = 10, bool $isIntranet = false, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSpotCheckResult(array_merge($_params, ["uuid" => $uuid, "skip" => $skip, "limit" => $limit, "isIntranet" => $isIntranet]));
    }

    /**
     * 获取抽片历史记录--2.27
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getSearchHistory (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSearchHistory(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 获取今日抽片指标
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStatistics () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStatistics();
    }

    /**
     * 云学院提交评价
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function commitHistory (string $spotUuid, string $uuid, int $photoId, int $scaleId, string $picUrl = '', array $tags = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->commitHistory(array_merge($_params, ["spotUuid" => $spotUuid, "uuid" => $uuid, "photoId" => $photoId, "scaleId" => $scaleId, "picUrl" => $picUrl, "tags" => $tags]));
    }

    /**
     * 更新云学院修改提交评价----2.6更新
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function updateCommitHistory (string $uuid, int $photoId, int $scaleId, string $picUrl = '', array $tags = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCommitHistory(array_merge($_params, ["uuid" => $uuid, "photoId" => $photoId, "scaleId" => $scaleId, "picUrl" => $picUrl, "tags" => $tags]));
    }

    /**
     * 获取更新云学院修改提交评价记录----2.6更新
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getUpdateCommitHistoryLog (int $page, int $pageSize, string $startAt, string $endAt, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUpdateCommitHistoryLog(array_merge($_params, ["page" => $page, "pageSize" => $pageSize, "startAt" => $startAt, "endAt" => $endAt]));
    }

    /**
     * 抽片池配置修改-test
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function fixCheckPoolConfig (array $configData) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixCheckPoolConfig(["configData" => $configData]);
    }

    /**
     * 添加云学院类别 ---v2.24
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  int
    */
    public static function addScoreType (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addScoreType(["name" => $name]);
    }

    /**
     * 修改云学院类别 ---v2.24
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function editScoreType (int $id, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editScoreType(["id" => $id, "name" => $name]);
    }

    /**
     * 获取云学院评分配置列表 ---v2.24
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getScoreConfigList (bool $withTrashed = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getScoreConfigList(["withTrashed" => $withTrashed]);
    }

    /**
     * 添加云学院评分配置---v2.24
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function addScoreConfig (string $name, array $children, int $scoreTypeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addScoreConfig(["name" => $name, "children" => $children, "scoreTypeId" => $scoreTypeId]);
    }

    /**
     * 修改云学院评分配置---v2.24
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function editScoreConfig (int $id, string $name, array $children) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editScoreConfig(["id" => $id, "name" => $name, "children" => $children]);
    }

    /**
     * 删除云学院评分配置---v2.24
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delScoreConfig (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delScoreConfig(["id" => $id]);
    }

    /**
     * 获取云学院修图师分数统计(柱状图)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getCloudScoreByStaffIds (string $startAt, string $endAt, array $staffIds, array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudScoreByStaffIds(["startAt" => $startAt, "endAt" => $endAt, "staffIds" => $staffIds, "productIds" => $productIds]);
    }

    /**
     * 获取云学院修图组分数统计(柱状图) ---2.24更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getCloudScoreByGroup (string $startAt, string $endAt, array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudScoreByGroup(["startAt" => $startAt, "endAt" => $endAt, "productIds" => $productIds]);
    }

    /**
     * 获取云学院修图组分数统计(柱状图) ---2.24更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getCloudProblemByGroup (string $startAt, string $endAt, int $scoreTypeId = 0, array $tagIds = [], array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudProblemByGroup(["startAt" => $startAt, "endAt" => $endAt, "scoreTypeId" => $scoreTypeId, "tagIds" => $tagIds, "productIds" => $productIds]);
    }

    /**
     * 清空云学院记录 ---2.8更新
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function emptyCheckPoolByStaffId (array $staffIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->emptyCheckPoolByStaffId(["staffIds" => $staffIds]);
    }

    /**
     * 获取评分人列表 ---2.8更新
     * @return  mixed
    */
    public static function getTakeStaffList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTakeStaffList();
    }

    /**
     * 获取老评分列表 ---2.8更新
     * @return  mixed
    */
    public static function getOldScoreConfigList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOldScoreConfigList();
    }

    /**
     * 云学院换一单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function changeItem (string $spotUuid, string $uuid, bool $isIntranet = false, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeItem(array_merge($_params, ["spotUuid" => $spotUuid, "uuid" => $uuid, "isIntranet" => $isIntranet]));
    }

    /**
     * 云学院-跳过伙伴
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function skipStaff (string $uuid, string $spotUuid, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->skipStaff(array_merge($_params, ["uuid" => $uuid, "spotUuid" => $spotUuid]));
    }

    /**
     * 云学院检查换一单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hasChangeItem (string $spotUuid, string $uuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hasChangeItem(["spotUuid" => $spotUuid, "uuid" => $uuid]);
    }

    /**
     * 设置评分档位
     * @return  mixed
    */
    public static function setScoreScale (\Mainto\Bridge\Structs\ProjectCloud\Objects\CheckPool\ScoreScales $scoreScales) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setScoreScale($scoreScales);
    }

    /**
     * 获取评分档位
     * @return  array
    */
    public static function getScoreScale () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getScoreScale(),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\CheckPool\ScoreScaleDTO[]"
        );
    }

    /**
     * 抽片试点
     * @return  bool
    */
    public static function isCheckPoolExperiment () {
        return RpcClass::getClass(self::$serviceName, self::$className)->isCheckPoolExperiment();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}