<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-02-17 17:49:55
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Operator
 * @method urgentStreamByParams(array $params) 加急流水
 * @method getRetouchStreamListByParams(array $params) 获取修片流水列表
 * @method getQueueStreamListByParams(array $params) 获取修片队列流水列表
 * @method getServantStreamListByParams(array $params) 获取指派队列列表
 * @method releaseServantStreamByParams(array $params) releaseServantStream
 * @method queueStreamListCountByParams(array $params) 获取修片队列流水数量
 * @method getStreamListByParams(array $params) 获取流水列表
 * @method getFlowInfoByParams(array $params) 获取流水看板数据
 * @method getCloudRetoucherQuotaByParams(array $params) 获取云端工作指标
 * @method editRetoucherGroupTargetQuotaByParams(array $params) 编辑修图组目标指标[今日]
 * @method getRetoucherQuotaByParams(array $params) 获取伙伴绩效
 * @method getAllCloudStreamByParams(array $params) 云端全流水查询&lt;2.24更新接口&gt;
 * @method getWholeQuotaByParams(array $params) 获取总体绩效&lt;2.10更新接口&gt;
 * @method getCheckPoolQuotaByParams(array $params) 获取云学院报告绩效&lt;2.10更新接口&gt;
 * @method getCheckPoolSubQuotaByParams(array $params) 获取云学院报告绩效&lt;2.24更新接口&gt;
 * @method getShowPicPoolSubQuotaByParams(array $params) 获取修修兽抽片报告绩效&lt;2.24更新接口&gt;
 * @method getStreamTimesQuotaByParams(array $params) 获取流水时间指标&lt;2.10更新接口&gt;
 * @method getOrgStandardTimesQuotaByParams(array $params) 获取流水时间指标&lt;2.10更新接口&gt;
 * @method getStoreReturnQuotaByParams(array $params) 获取门店退回指标&lt;2.10更新接口&gt;
 * @method getReviewQuotaByParams(array $params) 获取审核绩效[审与被审]
 * @method getStoreEvaluateByParams(array $params) 获取门店评价
 * @method getStreamInfoByParams(array $params) 获取流水信息【只能查到未审核通过流水】
 * @method modifyStreamByParams(array $params) 更改流水信息【只能修改未审核通过流水】
 * @method addRetouchOrgByParams(array $params) 添加修图机构
 * @method enableRetouchOrgByParams(array $params) 启动修图机构
 * @method disableRetouchOrgByParams(array $params) 禁用修图机构
 * @method editRetouchOrgByParams(array $params) 修改修图机构
 * @method getRetouchOrgInfoByParams(array $params) 获取修图机构信息
 * @method getRetouchOrgListByParams(array $params) 获取修图机构列表
 * @method addPhotographerOrgByParams(array $params) 添加摄影机构
 * @method editPhotographerOrgByParams(array $params) 修改摄影机构
 * @method getPhotographerOrgListByParams(array $params) 获取摄影机构列表
 * @method enablePhotographerOrgByParams(array $params) 启用摄影机构
 * @method disablePhotographerOrgByParams(array $params) 禁用摄影机构
 * @method getPhotographerOrgInfoByParams(array $params) 获取摄影机构信息
 * @method getRetouchOrgIncomeByParams(array $params) 获取修图机构绩效
 * @method setSupervisorOnDutyByParams(array $params) 设置值班主管
 * @method getSupervisorOnDutyByParams(array $params) 获取值班主管
 * @method manualReviewByParams(array $params) 手动直接审核
 * @method batchSaveStaffScoresByParams(array $params) 批量保存staff打分信息-不检查staffId-2.8
 * @method editStaffScoreByParams(array $params) 编辑staff分数-不检查staffId-2.8
 * @method getStaffScoresByParams(array $params) 获取staff分数列表-不检查staffId-2.8
 * @method returnStreamToQueueByParams(array $params) 大单退回
 */
class Operator {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Operator";

    /**
     * 加急流水
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function urgentStream (int $streamId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->urgentStream(array_merge($_params, ["streamId" => $streamId]));
    }

    /**
     * 获取修片流水列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getRetouchStreamList (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchStreamList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 获取修片队列流水列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getQueueStreamList (string $streamState, int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getQueueStreamList(array_merge($_params, ["streamState" => $streamState, "page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 获取指派队列列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getServantStreamList (string $retoucherStandard = null, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServantStreamList(["retoucherStandard" => $retoucherStandard, "page" => $page, "pageSize" => $pageSize]);
    }

    /**
     * releaseServantStream
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function releaseServantStream (string $streamNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->releaseServantStream(["streamNum" => $streamNum]);
    }

    /**
     * 获取修片队列流水数量
     * @return  mixed
    */
    public static function queueStreamListCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->queueStreamListCount();
    }

    /**
     * 获取流水列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStreamList (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 获取流水看板数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getFlowInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getFlowInfo();
    }

    /**
     * 获取云端工作指标
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getCloudRetoucherQuota (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudRetoucherQuota(array_merge($_params, []));
    }

    /**
     * 编辑修图组目标指标[今日]
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function editRetoucherGroupTargetQuota (int $expectPhotoNum, int $groupId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editRetoucherGroupTargetQuota(array_merge($_params, ["expectPhotoNum" => $expectPhotoNum, "groupId" => $groupId]));
    }

    /**
     * 获取伙伴绩效
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getRetoucherQuota (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetoucherQuota(array_merge($_params, []));
    }

    /**
     * 云端全流水查询&lt;2.24更新接口&gt;
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getAllCloudStream (int $page = 1, int $pageSize = 10, array $retoucherIds = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllCloudStream(array_merge($_params, ["page" => $page, "pageSize" => $pageSize, "retoucherIds" => $retoucherIds]));
    }

    /**
     * 获取总体绩效&lt;2.10更新接口&gt;
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getWholeQuota (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWholeQuota(array_merge($_params, []));
    }

    /**
     * 获取云学院报告绩效&lt;2.10更新接口&gt;
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getCheckPoolQuota (string $startAt, string $endAt, array $retoucherIds = [], array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCheckPoolQuota(["startAt" => $startAt, "endAt" => $endAt, "retoucherIds" => $retoucherIds, "productIds" => $productIds]);
    }

    /**
     * 获取云学院报告绩效&lt;2.24更新接口&gt;
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getCheckPoolSubQuota (string $startAt, string $endAt, array $retoucherIds = [], array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCheckPoolSubQuota(["startAt" => $startAt, "endAt" => $endAt, "retoucherIds" => $retoucherIds, "productIds" => $productIds]);
    }

    /**
     * 获取修修兽抽片报告绩效&lt;2.24更新接口&gt;
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getShowPicPoolSubQuota (string $startAt, string $endAt, array $retoucherIds = [], array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShowPicPoolSubQuota(["startAt" => $startAt, "endAt" => $endAt, "retoucherIds" => $retoucherIds, "productIds" => $productIds]);
    }

    /**
     * 获取流水时间指标&lt;2.10更新接口&gt;
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStreamTimesQuota (string $startAt, string $endAt, int $retouchGroup = 0, string $retouchClass = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamTimesQuota(["startAt" => $startAt, "endAt" => $endAt, "retouchGroup" => $retouchGroup, "retouchClass" => $retouchClass]);
    }

    /**
     * 获取流水时间指标&lt;2.10更新接口&gt;
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getOrgStandardTimesQuota (string $startAt, string $endAt, int $retouchGroup = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrgStandardTimesQuota(["startAt" => $startAt, "endAt" => $endAt, "retouchGroup" => $retouchGroup]);
    }

    /**
     * 获取门店退回指标&lt;2.10更新接口&gt;
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStoreReturnQuota (string $startAt, string $endAt, array $retouchIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreReturnQuota(["startAt" => $startAt, "endAt" => $endAt, "retouchIds" => $retouchIds]);
    }

    /**
     * 获取审核绩效[审与被审]
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getReviewQuota (string $startAt, string $endAt, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReviewQuota(array_merge($_params, ["startAt" => $startAt, "endAt" => $endAt]));
    }

    /**
     * 获取门店评价
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStoreEvaluate (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreEvaluate(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 获取流水信息【只能查到未审核通过流水】
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStreamInfo (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamInfo(array_merge($_params, []));
    }

    /**
     * 更改流水信息【只能修改未审核通过流水】
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function modifyStream (int $streamId, array $photos, int $productId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyStream(array_merge($_params, ["streamId" => $streamId, "photos" => $photos, "productId" => $productId]));
    }

    /**
     * 添加修图机构
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addRetouchOrg (string $name, string $code, string $account, array $enableProductIds, array $incomeConfig, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addRetouchOrg(array_merge($_params, ["name" => $name, "code" => $code, "account" => $account, "enableProductIds" => $enableProductIds, "incomeConfig" => $incomeConfig]));
    }

    /**
     * 启动修图机构
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function enableRetouchOrg (int $retouchOrgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enableRetouchOrg(["retouchOrgId" => $retouchOrgId]);
    }

    /**
     * 禁用修图机构
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function disableRetouchOrg (int $retouchOrgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->disableRetouchOrg(["retouchOrgId" => $retouchOrgId]);
    }

    /**
     * 修改修图机构
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function editRetouchOrg (int $retouchOrgId, array $enableProductIds, string $secret = null, string $name, string $code, string $account, array $incomeConfig, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editRetouchOrg(array_merge($_params, ["retouchOrgId" => $retouchOrgId, "enableProductIds" => $enableProductIds, "secret" => $secret, "name" => $name, "code" => $code, "account" => $account, "incomeConfig" => $incomeConfig]));
    }

    /**
     * 获取修图机构信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getRetouchOrgInfo (int $retouchOrgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchOrgInfo(["retouchOrgId" => $retouchOrgId]);
    }

    /**
     * 获取修图机构列表
     * @return  mixed
    */
    public static function getRetouchOrgList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchOrgList();
    }

    /**
     * 添加摄影机构
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function addPhotographerOrg (string $name, string $type, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addPhotographerOrg(array_merge($_params, ["name" => $name, "type" => $type]));
    }

    /**
     * 修改摄影机构
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function editPhotographerOrg (int $photographerOrgId, string $name, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editPhotographerOrg(array_merge($_params, ["photographerOrgId" => $photographerOrgId, "name" => $name]));
    }

    /**
     * 获取摄影机构列表
     * @return  mixed
    */
    public static function getPhotographerOrgList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotographerOrgList();
    }

    /**
     * 启用摄影机构
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function enablePhotographerOrg (int $photographerOrgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enablePhotographerOrg(["photographerOrgId" => $photographerOrgId]);
    }

    /**
     * 禁用摄影机构
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function disablePhotographerOrg (int $photographerOrgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->disablePhotographerOrg(["photographerOrgId" => $photographerOrgId]);
    }

    /**
     * 获取摄影机构信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getPhotographerOrgInfo (int $photographerOrgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotographerOrgInfo(["photographerOrgId" => $photographerOrgId]);
    }

    /**
     * 获取修图机构绩效
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getRetouchOrgIncome (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchOrgIncome(array_merge($_params, []));
    }

    /**
     * 设置值班主管
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function setSupervisorOnDuty (array $supervisorOnDutyData) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setSupervisorOnDuty(["supervisorOnDutyData" => $supervisorOnDutyData]);
    }

    /**
     * 获取值班主管
     * @return  array
    */
    public static function getSupervisorOnDuty () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSupervisorOnDuty(),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\SupervisorOnDuty\SupervisorOnDutyDTO[]"
        );
    }

    /**
     * 手动直接审核
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function manualReview (int $streamId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualReview(array_merge($_params, ["streamId" => $streamId]));
    }

    /**
     * 批量保存staff打分信息-不检查staffId-2.8
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function batchSaveStaffScores (array $staffScores, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSaveStaffScores(array_merge($_params, ["staffScores" => $staffScores]));
    }

    /**
     * 编辑staff分数-不检查staffId-2.8
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function editStaffScore (int $id, float $score, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStaffScore(array_merge($_params, ["id" => $id, "score" => $score]));
    }

    /**
     * 获取staff分数列表-不检查staffId-2.8
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStaffScores (string $type, string $cycle, int $page = 1, int $pageSize = 20, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffScores(array_merge($_params, ["type" => $type, "cycle" => $cycle, "page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 大单退回
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function returnStreamToQueue (int $streamId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->returnStreamToQueue(array_merge($_params, ["streamId" => $streamId]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}