<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-03-05 17:10:09
 */
namespace Mainto\Bridge\Structs\ProjectCloud\Objects\Api\Stream;

class StoreReturnStream {
    /**
     * @var  string
     * 流水号
     * validation: 
     */
    public string $streamNum;
    /**
     * @var  null|int
     * 指派修图师id, 为null或0表示随机修图师，退回队列，原修图师不可取该流水
     * validation: 
     */
    public ?int $assignRetoucherId = null;
    /**
     * @var  \Mainto\Bridge\Structs\ProjectCloud\Objects\Api\Stream\StoreReturnStreamPhotoData[]
     * 退回照片
     * validation: 
     */
    public array $photoData;
    /**
     * @var  string
     * 退回来源, offline:线下退回，online:在线看片退回
     * validation: 
     */
    public string $source = "offline";
    /**
     * @var  null|int
     * 机构id
     * validation: 
     */
    public ?int $orgId = null;
    /**
     * @var  null|string
     * apiToken鉴权
     * validation: 
     */
    public ?string $apiAccessToken = null;

    public function __construct (string $streamNum = '', array $photoData = []) {
        if (!is_null($streamNum)) {
            $this->streamNum = $streamNum;
        }
        if (!is_null($photoData)) {
            $this->photoData = $photoData;
        }
    }

    public static function create(string $streamNum = '', array $photoData = []): self {
        return new self($streamNum, $photoData);
    }

    public function setStreamNum(string $streamNum): self {
        $this->streamNum = $streamNum;

        return $this;
    }

    public function setAssignRetoucherId(?int $assignRetoucherId): self {
        $this->assignRetoucherId = $assignRetoucherId;

        return $this;
    }

    public function setPhotoData(array $photoData): self {
        $this->photoData = $photoData;

        return $this;
    }

    public function setSource(string $source): self {
        $this->source = $source;

        return $this;
    }

    public function setOrgId(?int $orgId): self {
        $this->orgId = $orgId;

        return $this;
    }

    public function setApiAccessToken(?string $apiAccessToken): self {
        $this->apiAccessToken = $apiAccessToken;

        return $this;
    }
}