<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-19 12:08:58
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Appeal
 * @method addByParams(array $params) 发起申诉-v2.12
 * @method listByParams(array $params) 申诉列表-v2.12
 * @method detailByParams(array $params) 申诉详情-v2.12
 * @method examineFirstByParams(array $params) 初审-v2.12
 * @method examineSecondByParams(array $params) 复审-v2.12
 * @method bindFirstByParams(array $params) 初审绑定-v2.12
 * @method bindSecondByParams(array $params) 复审绑定-v2.12
 * @method getReworkStreamTypeByParams(array $params) 申诉退单问题分类
 */
class Appeal {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Appeal";

    /**
     * 发起申诉-v2.12
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function add (int $streamId, string $type, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->add(array_merge($_params, ["streamId" => $streamId, "type" => $type]));
    }

    /**
     * 申诉列表-v2.12
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function list (int $groupId = 0, int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(array_merge($_params, ["groupId" => $groupId, "page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * 申诉详情-v2.12
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 初审-v2.12
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function examineFirst (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->examineFirst(array_merge($_params, ["id" => $id]));
    }

    /**
     * 复审-v2.12
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function examineSecond (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->examineSecond(array_merge($_params, ["id" => $id]));
    }

    /**
     * 初审绑定-v2.12
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function bindFirst (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindFirst(array_merge($_params, ["id" => $id]));
    }

    /**
     * 复审绑定-v2.12
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function bindSecond (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindSecond(array_merge($_params, ["id" => $id]));
    }

    /**
     * 申诉退单问题分类
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getReworkStreamType (int $id) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getReworkStreamType(["id" => $id]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\Appeal\GetReworkStreamTypeByStreamIdDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}