<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPhotoListByParams(array $params)
 * @method getPhotoListV2ByParams(array|\Mainto\Bridge\Structs\ProjectCloud\CMD\SearchPoolPhotoCMD $params)
 * @method getPhotoInfoByParams(array $params)
 * @method getPhotoInfoV2ByParams(array $params)
 * @method submitAttitudeByParams(array $params)
 * @method submitAttitudeV2ByParams(array $params)
 * @method getAttitudePhotoInfoByParams(array $params)
 * @method getAttitudePhotoInfoV2ByParams(array $params)
 * @method getAttitudePhotoListByParams(array $params)
 * @method getAttitudePhotoListV2ByParams(array|\Mainto\Bridge\Structs\ProjectCloud\CMD\SearchAttitudePoolPhotoCMD $params)
 * @method getPhotoStreamInfoByParams(array $params)
 * @method getSimilarPhotoListByParams(array $params)
 */
class PhotoPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取客片列表
     *
     * @support  string $startAt 开始时间 [ require false ]
     * @support  string $endAt 结束时间 [ require false ]
     * @support  array $staffIds 伙伴id [ require false ]
     * @support  string $streamNum 云图流水号 [ require false ]
     * @support  string $orderNum 订单号 [ require false ]
     * @support  string $customerName 顾客姓名 [ require false ]
     * @support  string $telephone 手机号 [ require false ]
     * @support  string $photoVersion 照片版本 [ require false ]
     * @support  array $productIds 产品Ids [ require false ]
     * @support  array $retouchStandards 修片标准 [ require false ]
     * @support  int $evaluateStar 评价星级 [ require false ]
     * @param  int $page 页面 [ require false ]
     * @param  int $pageSize 每页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotoList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getPhotoList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取客片列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloud\CMD\SearchPoolPhotoCMD $searchPoolPhoto
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolListDTO
     */
    public static function getPhotoListV2 (\Mainto\Bridge\Structs\ProjectCloud\CMD\SearchPoolPhotoCMD $searchPoolPhoto) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPhotoListV2($searchPoolPhoto),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolListDTO"
        );
    }


    /**
     * 获取客片详情
     *
     * @param  string $photoUuid 照片uuid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotoInfo (string $photoUuid) {
        return self::getClass()->getPhotoInfo([
            "photoUuid" => $photoUuid,
        ]);
    }

    /**
     * 获取客片详情V2
     *
     * @param  string $photoId 照片id(照片中台的id) [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolInfoDTO
     */
    public static function getPhotoInfoV2 (string $photoId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPhotoInfoV2([
                            "photoId" => $photoId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolInfoDTO"
        );
    }

    /**
     * 提交【踩/赞】
     *
     * @param  int $photoId 图片版本id [ require true ]
     * @param  string $attitude 态度【赞，踩, 无】 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitAttitude (int $photoId, string $attitude) {
        return self::getClass()->submitAttitude([
            "photoId" => $photoId,
            "attitude" => $attitude,
        ]);
    }

    /**
     * 提交【踩/赞】V2
     *
     * @param  string $photoId 图片版本id [ require true ]
     * @param  string $attitude 态度【赞，踩, 无】 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitAttitudeV2 (string $photoId, string $attitude) {
        return self::getClass()->submitAttitudeV2([
            "photoId" => $photoId,
            "attitude" => $attitude,
        ]);
    }

    /**
     * 获取赞或踩客片详情
     *
     * @param  string $photoUuid 照片uuid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAttitudePhotoInfo (string $photoUuid) {
        return self::getClass()->getAttitudePhotoInfo([
            "photoUuid" => $photoUuid,
        ]);
    }

    /**
     * 获取赞或踩客片详情V2
     *
     * @param  string $photoId 照片中台id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolAttitudeInfoDTO
     */
    public static function getAttitudePhotoInfoV2 (string $photoId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAttitudePhotoInfoV2([
                            "photoId" => $photoId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolAttitudeInfoDTO"
        );
    }

    /**
     * 获取优秀/问题客片列表
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  string $attitude 态度【赞，踩, 无】 [ require true ]
     * @support  array $staffIds 伙伴id [ require false ]
     * @support  array $productId 产品ID [ require false ]
     * @support  string $retouchStandard 修片标准 [ require false ]
     * @param  int $page 页面 [ require false ]
     * @param  int $pageSize 每页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAttitudePhotoList (string $startAt, string $endAt, string $attitude, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getAttitudePhotoList([
            "startAt" => $startAt,
            "endAt" => $endAt,
            "attitude" => $attitude,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取优秀/问题客片列表V2
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloud\CMD\SearchAttitudePoolPhotoCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolAttitudeListDTO
     */
    public static function getAttitudePhotoListV2 (\Mainto\Bridge\Structs\ProjectCloud\CMD\SearchAttitudePoolPhotoCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAttitudePhotoListV2($cmd),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\PhotoPool\PhotoPoolAttitudeListDTO"
        );
    }


    /**
     * 获取照片流水与照片信息
     *
     * @param  string $imagePath 照片path [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotoStreamInfo (string $imagePath) {
        return self::getClass()->getPhotoStreamInfo([
            "imagePath" => $imagePath,
        ]);
    }

    /**
     * 获取相似照片列表
     *
     * @param  string $imageKey 图片路径 [ require true ]
     * @param  int $top 取出照片数，前XX张，默认为5 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSimilarPhotoList (string $imageKey, int $top = 5) {
        return self::getClass()->getSimilarPhotoList([
            "imageKey" => $imageKey,
            "top" => $top,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'PhotoPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'PhotoPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}