<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-14 09:31:10
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Retoucher
 */
class Retoucher {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Retoucher";

    /**
     * 进入队列
     * @return  mixed
    */
    public static function joinQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->joinQueue();
    }
    /**
     * 退出队列
     * @return  mixed
    */
    public static function exitQueue () {
        return RpcClass::getClass(self::$serviceName, self::$className)->exitQueue();
    }
    /**
     * 有流水退单[有就返回流水单号]
     * @return  mixed
    */
    public static function haveReworkStream () {
        return RpcClass::getClass(self::$serviceName, self::$className)->haveReworkStream();
    }
    /**
     * 获取流水信息[沙漏时间会自减]--2.27
     * @return  mixed
    */
    public static function getStreamInfo (int $streamId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamInfo(["streamId" => $streamId]);
    }
    /**
     * 获取流水列表[待修，挂起]
     * @return  mixed
    */
    public static function getRetouchStreams (string $state) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchStreams(["state" => $state]);
    }
    /**
     * 获取待修片队列信息
     * @return  mixed
    */
    public static function getStreamQueueInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamQueueInfo();
    }
    /**
     * 提交已修流水
     * @return  bool
    */
    public static function submitStream (\Mainto\Bridge\Structs\ProjectCloud\Objects\Stream\SubmitStream $submitStream) {
        return RpcClass::getClass(self::$serviceName, self::$className)->submitStream($submitStream);
    }
    /**
     * 挂起流水[仅能挂起缦图订单]
     * @return  mixed
    */
    public static function hangStream (int $streamId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hangStream(["streamId" => $streamId]);
    }
    /**
     * 获取个人修图等级信息
     * @return  mixed
    */
    public static function getRankInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRankInfo();
    }
    /**
     * 获取道具
     * @return  mixed
    */
    public static function getProps () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProps();
    }
    /**
     * 使用道具
     * @return  mixed
    */
    public static function useProp (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->useProp(["id" => $id]);
    }
    /**
     * 获取小蜜蜂奖励信息
     * @return  mixed
    */
    public static function getLittleBeeInfo (int $year) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLittleBeeInfo(["year" => $year]);
    }
    /**
     * 获取历史修图报告列表&lt;2.10更新接口&gt;
     * @return  mixed
    */
    public static function getRetouchQuotaList (string $streamNum = '', string $startAt = '', string $endAt = '', int $page = 1, int $pageSize = 10, bool $isReturn, string $cloudEvaluateType, bool $isReturned, string $evaluate, string $storeReworkType, array $cloudTags) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchQuotaList(["streamNum" => $streamNum, "startAt" => $startAt, "endAt" => $endAt, "page" => $page, "pageSize" => $pageSize, "isReturn" => $isReturn, "cloudEvaluateType" => $cloudEvaluateType, "isReturned" => $isReturned, "evaluate" => $evaluate, "storeReworkType" => $storeReworkType, "cloudTags" => $cloudTags]);
    }
    /**
     * 获取个人buff信息
     * @return  mixed
    */
    public static function getSelfBuffInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSelfBuffInfo();
    }
    /**
     * 在线
     * @return  mixed
    */
    public static function online () {
        return RpcClass::getClass(self::$serviceName, self::$className)->online();
    }
    /**
     * 离线
     * @return  mixed
    */
    public static function offline (string $action) {
        return RpcClass::getClass(self::$serviceName, self::$className)->offline(["action" => $action]);
    }
    /**
     * 获取在线状态
     * @return  mixed
    */
    public static function getOnlineState () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOnlineState();
    }
    /**
     * 获取组员云学院报告绩效&lt;2.10更新接口&gt;
     * @return  mixed
    */
    public static function getCheckPoolQuota (string $startAt, string $endAt, array $retoucherIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCheckPoolQuota(["startAt" => $startAt, "endAt" => $endAt, "retoucherIds" => $retoucherIds]);
    }
    /**
     * 获取组员云学院报告绩效&lt;2.24更新接口&gt;
     * @return  mixed
    */
    public static function getCheckPoolSubQuota (string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCheckPoolSubQuota(["startAt" => $startAt, "endAt" => $endAt]);
    }
    /**
     * 获取组员修修兽抽片报告绩效&lt;2.24更新接口&gt;
     * @return  mixed
    */
    public static function getShowPicPoolSubQuota (string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShowPicPoolSubQuota(["startAt" => $startAt, "endAt" => $endAt]);
    }
    /**
     * 修图师自身申诉列表-v2.12
     * @return  mixed
    */
    public static function getAppealList (int $page = 1, int $pageSize = 10, \Mainto\Bridge\Structs\ProjectCloud\Retoucher\GetAppealListParamsCond $cond, array $cond) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAppealList(["page" => $page, "pageSize" => $pageSize, "cond" => $cond, "cond" => $cond]);
    }
    /**
     * 申诉详情-v2.12
     * @return  mixed
    */
    public static function appealDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->appealDetail(["id" => $id]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}