<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-11 18:00:40
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\Trainning;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class TrainPlan
 */
class TrainPlan {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Trainning\\TrainPlan";

    /**
     * 创建星耀计划
     * @return  int
    */
    public static function createTrainPlan (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\TrainPlanConfig\CreateTrainPlan $createTrainPlan) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createTrainPlan($createTrainPlan);
    }
    /**
     * 修改星耀计划配置
     * @return  int
    */
    public static function editTrainPlan (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\TrainPlanConfig\EditTrainPlan $editTrainPlan) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editTrainPlan($editTrainPlan);
    }
    /**
     * 考核配置
     * @return  int
    */
    public static function createExamConfig (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\ExamConfig\CreateExamConfig $createExamConfig) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createExamConfig($createExamConfig);
    }
    /**
     * 修改考核配置
     * @return  int
    */
    public static function editExamConfig (\Mainto\Bridge\Structs\ProjectCloud\Objects\Trainning\ExamConfig\EditExamConfig $editExamConfig) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editExamConfig($editExamConfig);
    }
    /**
     * 删除考核配置
     * @return  mixed
    */
    public static function delExamConfig (int $examConfigId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delExamConfig(["examConfigId" => $examConfigId]);
    }
    /**
     * 通关配置
     * @return  mixed
    */
    public static function createPassConfig (int $planId, string $draftUuid, bool $isEdit = false, int $retouchClassId, array $passProductConfig, array $retoucherIds, array $markingMentorIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPassConfig(["planId" => $planId, "draftUuid" => $draftUuid, "isEdit" => $isEdit, "retouchClassId" => $retouchClassId, "passProductConfig" => $passProductConfig, "retoucherIds" => $retoucherIds, "markingMentorIds" => $markingMentorIds]);
    }
    /**
     * 获取星耀计划配置详情
     * @return  array
    */
    public static function getTrainPlanDetail (int $planId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTrainPlanDetail(["planId" => $planId]);
    }
    /**
     * 星耀培训计划列表
     * @return  array
    */
    public static function getTrainPlanList (string $startAt, string $endAt, string $titleLike, array $typeIn, array $stateIn, bool $onlyMarkingToMe, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTrainPlanList(["startAt" => $startAt, "endAt" => $endAt, "titleLike" => $titleLike, "typeIn" => $typeIn, "stateIn" => $stateIn, "onlyMarkingToMe" => $onlyMarkingToMe, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 草稿存储
     * @return  mixed
    */
    public static function saveTrainPlanDraft (array $contentArr, string $step, int $planId = null, string $draftUuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveTrainPlanDraft(["contentArr" => $contentArr, "step" => $step, "planId" => $planId, "draftUuid" => $draftUuid]);
    }
    /**
     * 创建星耀培训计划--获取草稿
     * @return  array
    */
    public static function getTrainPlanDraft (int $planId = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTrainPlanDraft(["planId" => $planId]);
    }
    /**
     * 创建星耀培训计划--删除
     * @return  bool
    */
    public static function delTrainPlan (int $planId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delTrainPlan(["planId" => $planId]);
    }
    /**
     * 星耀计划 -- 数据面板
     * @return  array
    */
    public static function planDataAgg (int $planId, array $staffIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->planDataAgg(["planId" => $planId, "staffIds" => $staffIds]);
    }
    /**
     * 校验培训伙伴
     * @return  \Mainto\Bridge\Structs\ProjectCloud\DTO\TrainPlan\CheckJoinStaff\CheckJoinStaffResultDTO
    */
    public static function checkJoinStaff (array $staff) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->checkJoinStaff(["staff" => $staff]),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\TrainPlan\CheckJoinStaff\CheckJoinStaffResultDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}