<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-03 18:20:07
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Operator
 */
class Operator {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Operator";

    /**
     * 加急流水
     * @return  bool
    */
    public static function urgentStream (int $streamId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->urgentStream(["streamId" => $streamId]);
    }
    /**
     * 获取修片流水列表
     * @return  array
    */
    public static function getRetouchStreamList (int $page = 1, int $pageSize = 10, string $retoucherStandard, string $streamState) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchStreamList(["page" => $page, "pageSize" => $pageSize, "retoucherStandard" => $retoucherStandard, "streamState" => $streamState]);
    }
    /**
     * 获取修片队列流水列表
     * @return  mixed
    */
    public static function getQueueStreamList (string $streamState, int $page = 1, int $pageSize = 10, string $retoucherStandard) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getQueueStreamList(["streamState" => $streamState, "page" => $page, "pageSize" => $pageSize, "retoucherStandard" => $retoucherStandard]);
    }
    /**
     * 获取指派队列列表
     * @return  array
    */
    public static function getServantStreamList (string $retoucherStandard = null, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServantStreamList(["retoucherStandard" => $retoucherStandard, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * releaseServantStream
     * @return  bool
    */
    public static function releaseServantStream (string $streamNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->releaseServantStream(["streamNum" => $streamNum]);
    }
    /**
     * 获取修片队列流水数量
     * @return  mixed
    */
    public static function queueStreamListCount () {
        return RpcClass::getClass(self::$serviceName, self::$className)->queueStreamListCount();
    }
    /**
     * 获取流水列表
     * @return  mixed
    */
    public static function getStreamList (int $page = 1, int $pageSize = 10, string $customerName, string $orderNum, string $streamNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamList(["page" => $page, "pageSize" => $pageSize, "customerName" => $customerName, "orderNum" => $orderNum, "streamNum" => $streamNum]);
    }
    /**
     * 获取流水看板数据
     * @return  mixed
    */
    public static function getFlowInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getFlowInfo();
    }
    /**
     * 获取云端工作指标
     * @return  mixed
    */
    public static function getCloudRetoucherQuota (string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudRetoucherQuota(["startAt" => $startAt, "endAt" => $endAt]);
    }
    /**
     * 编辑修图组目标指标[今日]
     * @return  mixed
    */
    public static function editRetoucherGroupTargetQuota (int $expectPhotoNum, int $groupId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editRetoucherGroupTargetQuota(["expectPhotoNum" => $expectPhotoNum, "groupId" => $groupId]);
    }
    /**
     * 获取伙伴绩效
     * @return  mixed
    */
    public static function getRetoucherQuota (string $startAt, string $endAt, array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetoucherQuota(["startAt" => $startAt, "endAt" => $endAt, "staffIds" => $staffIds]);
    }
    /**
     * 云端全流水查询&lt;2.24更新接口&gt;
     * @return  mixed
    */
    public static function getAllCloudStream (int $page = 1, int $pageSize = 10, array $retoucherIds = [], string $evaluate, string $storeReworkType, array $cloudTags, string $cloudEvaluateType, string $passStartAt, string $passEndAt, string $returnStartAt, string $returnEndAt, string $storeEvaluateStartAt, string $storeEvaluateEndAt, string $cloudEvaluateStartAt, string $cloudEvaluateEndAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllCloudStream(["page" => $page, "pageSize" => $pageSize, "retoucherIds" => $retoucherIds, "evaluate" => $evaluate, "storeReworkType" => $storeReworkType, "cloudTags" => $cloudTags, "cloudEvaluateType" => $cloudEvaluateType, "passStartAt" => $passStartAt, "passEndAt" => $passEndAt, "returnStartAt" => $returnStartAt, "returnEndAt" => $returnEndAt, "storeEvaluateStartAt" => $storeEvaluateStartAt, "storeEvaluateEndAt" => $storeEvaluateEndAt, "cloudEvaluateStartAt" => $cloudEvaluateStartAt, "cloudEvaluateEndAt" => $cloudEvaluateEndAt]);
    }
    /**
     * 获取总体绩效&lt;2.10更新接口&gt;
     * @return  mixed
    */
    public static function getWholeQuota (string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWholeQuota(["startAt" => $startAt, "endAt" => $endAt]);
    }
    /**
     * 获取云学院报告绩效&lt;2.10更新接口&gt;
     * @return  mixed
    */
    public static function getCheckPoolQuota (string $startAt, string $endAt, array $retoucherIds = [], array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCheckPoolQuota(["startAt" => $startAt, "endAt" => $endAt, "retoucherIds" => $retoucherIds, "productIds" => $productIds]);
    }
    /**
     * 获取云学院报告绩效&lt;2.24更新接口&gt;
     * @return  mixed
    */
    public static function getCheckPoolSubQuota (string $startAt, string $endAt, array $retoucherIds = [], array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCheckPoolSubQuota(["startAt" => $startAt, "endAt" => $endAt, "retoucherIds" => $retoucherIds, "productIds" => $productIds]);
    }
    /**
     * 获取修修兽抽片报告绩效&lt;2.24更新接口&gt;
     * @return  mixed
    */
    public static function getShowPicPoolSubQuota (string $startAt, string $endAt, array $retoucherIds = [], array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getShowPicPoolSubQuota(["startAt" => $startAt, "endAt" => $endAt, "retoucherIds" => $retoucherIds, "productIds" => $productIds]);
    }
    /**
     * 获取流水时间指标&lt;2.10更新接口&gt;
     * @return  mixed
    */
    public static function getStreamTimesQuota (string $startAt, string $endAt, int $retouchGroup = 0, string $retouchClass = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamTimesQuota(["startAt" => $startAt, "endAt" => $endAt, "retouchGroup" => $retouchGroup, "retouchClass" => $retouchClass]);
    }
    /**
     * 获取流水时间指标&lt;2.10更新接口&gt;
     * @return  mixed
    */
    public static function getOrgStandardTimesQuota (string $startAt, string $endAt, int $retouchGroup = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrgStandardTimesQuota(["startAt" => $startAt, "endAt" => $endAt, "retouchGroup" => $retouchGroup]);
    }
    /**
     * 获取门店退回指标&lt;2.10更新接口&gt;
     * @return  mixed
    */
    public static function getStoreReturnQuota (string $startAt, string $endAt, array $retouchIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreReturnQuota(["startAt" => $startAt, "endAt" => $endAt, "retouchIds" => $retouchIds]);
    }
    /**
     * 获取审核绩效[审与被审]
     * @return  mixed
    */
    public static function getReviewQuota (string $startAt, string $endAt, int $reviewId, int $groupId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getReviewQuota(["startAt" => $startAt, "endAt" => $endAt, "reviewId" => $reviewId, "groupId" => $groupId]);
    }
    /**
     * 获取门店评价
     * @return  array
    */
    public static function getStoreEvaluate (int $page = 1, int $pageSize = 10, string $startAt, string $endAt, int $staffId, string $storeEvaluation) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreEvaluate(["page" => $page, "pageSize" => $pageSize, "startAt" => $startAt, "endAt" => $endAt, "staffId" => $staffId, "storeEvaluation" => $storeEvaluation]);
    }
    /**
     * 获取流水信息【只能查到未审核通过流水】
     * @return  mixed
    */
    public static function getStreamInfo (string $externalNum, string $streamNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStreamInfo(["externalNum" => $externalNum, "streamNum" => $streamNum]);
    }
    /**
     * 更改流水信息【只能修改未审核通过流水】
     * @return  bool
    */
    public static function modifyStream (int $streamId, array $photos, int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyStream(["streamId" => $streamId, "photos" => $photos, "productId" => $productId]);
    }
    /**
     * 添加修图机构
     * @return  mixed
    */
    public static function addRetouchOrg (string $name, string $code, string $account, string $secret, array $enableProductIds, array $incomeConfig) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addRetouchOrg(["name" => $name, "code" => $code, "account" => $account, "secret" => $secret, "enableProductIds" => $enableProductIds, "incomeConfig" => $incomeConfig]);
    }
    /**
     * 启动修图机构
     * @return  mixed
    */
    public static function enableRetouchOrg (int $retouchOrgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enableRetouchOrg(["retouchOrgId" => $retouchOrgId]);
    }
    /**
     * 禁用修图机构
     * @return  mixed
    */
    public static function disableRetouchOrg (int $retouchOrgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->disableRetouchOrg(["retouchOrgId" => $retouchOrgId]);
    }
    /**
     * 修改修图机构
     * @return  mixed
    */
    public static function editRetouchOrg (int $retouchOrgId, array $enableProductIds, string $secret = null, string $name, string $code, string $account, array $incomeConfig) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editRetouchOrg(["retouchOrgId" => $retouchOrgId, "enableProductIds" => $enableProductIds, "secret" => $secret, "name" => $name, "code" => $code, "account" => $account, "incomeConfig" => $incomeConfig]);
    }
    /**
     * 获取修图机构信息
     * @return  mixed
    */
    public static function getRetouchOrgInfo (int $retouchOrgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchOrgInfo(["retouchOrgId" => $retouchOrgId]);
    }
    /**
     * 获取修图机构列表
     * @return  mixed
    */
    public static function getRetouchOrgList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchOrgList();
    }
    /**
     * 添加摄影机构
     * @return  mixed
    */
    public static function addPhotographerOrg (string $name, string $code, string $account, string $secret, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addPhotographerOrg(["name" => $name, "code" => $code, "account" => $account, "secret" => $secret, "type" => $type]);
    }
    /**
     * 修改摄影机构
     * @return  mixed
    */
    public static function editPhotographerOrg (int $photographerOrgId, string $name, string $type, string $account, string $secret) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editPhotographerOrg(["photographerOrgId" => $photographerOrgId, "name" => $name, "type" => $type, "account" => $account, "secret" => $secret]);
    }
    /**
     * 获取摄影机构列表
     * @return  mixed
    */
    public static function getPhotographerOrgList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotographerOrgList();
    }
    /**
     * 启用摄影机构
     * @return  mixed
    */
    public static function enablePhotographerOrg (int $photographerOrgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enablePhotographerOrg(["photographerOrgId" => $photographerOrgId]);
    }
    /**
     * 禁用摄影机构
     * @return  mixed
    */
    public static function disablePhotographerOrg (int $photographerOrgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->disablePhotographerOrg(["photographerOrgId" => $photographerOrgId]);
    }
    /**
     * 获取摄影机构信息
     * @return  mixed
    */
    public static function getPhotographerOrgInfo (int $photographerOrgId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotographerOrgInfo(["photographerOrgId" => $photographerOrgId]);
    }
    /**
     * 获取修图机构绩效
     * @return  mixed
    */
    public static function getRetouchOrgIncome (int $retoucherOrgId, string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetouchOrgIncome(["retoucherOrgId" => $retoucherOrgId, "startAt" => $startAt, "endAt" => $endAt]);
    }
    /**
     * 设置值班主管
     * @return  mixed
    */
    public static function setSupervisorOnDuty (array $supervisorOnDutyData) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setSupervisorOnDuty(["supervisorOnDutyData" => $supervisorOnDutyData]);
    }
    /**
     * 获取值班主管
     * @return  array
    */
    public static function getSupervisorOnDuty () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSupervisorOnDuty(),
            "\Mainto\Bridge\Structs\ProjectCloud\DTO\SupervisorOnDuty\SupervisorOnDutyDTO[]"
        );
    }
    /**
     * 手动直接审核
     * @return  mixed
    */
    public static function manualReview (int $streamId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualReview(["streamId" => $streamId]);
    }
    /**
     * 批量保存staff打分信息-不检查staffId-2.8
     * @return  mixed
    */
    public static function batchSaveStaffScores (array $staffScores, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSaveStaffScores(["staffScores" => $staffScores, "type" => $type]);
    }
    /**
     * 编辑staff分数-不检查staffId-2.8
     * @return  mixed
    */
    public static function editStaffScore (int $id, float $score) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStaffScore(["id" => $id, "score" => $score]);
    }
    /**
     * 获取staff分数列表-不检查staffId-2.8
     * @return  mixed
    */
    public static function getStaffScores (string $type, string $cycle, int $page = 1, int $pageSize = 20, array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffScores(["type" => $type, "cycle" => $cycle, "page" => $page, "pageSize" => $pageSize, "staffIds" => $staffIds]);
    }
    /**
     * 大单退回
     * @return  mixed
    */
    public static function returnStreamToQueue (int $streamId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->returnStreamToQueue(["streamId" => $streamId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}