<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-03 18:20:07
 */
namespace Mainto\Bridge\Invokes\ProjectCloud\CheckPool;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CheckPool
 */
class CheckPool {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "CheckPool\\CheckPool";

    /**
     * 云学院抽片
     * @return  mixed
    */
    public static function takeItem (int $takeNum, string $submitStartAt, string $submitEndAt, array $productIds, bool $isOut) {
        return RpcClass::getClass(self::$serviceName, self::$className)->takeItem(["takeNum" => $takeNum, "submitStartAt" => $submitStartAt, "submitEndAt" => $submitEndAt, "productIds" => $productIds, "isOut" => $isOut]);
    }
    /**
     * 获取是否有未评分的抽片
     * @return  mixed
    */
    public static function getHaveSpotCheckResult () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHaveSpotCheckResult();
    }
    /**
     * 获取抽片结果--2.27
     * @return  mixed
    */
    public static function getSpotCheckResult (string $uuid, int $skip = 0, int $limit = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSpotCheckResult(["uuid" => $uuid, "skip" => $skip, "limit" => $limit]);
    }
    /**
     * 获取抽片历史记录--2.27
     * @return  mixed
    */
    public static function getSearchHistory (int $page = 1, int $pageSize = 10, string $startAt, string $endAt, array $retoucherIds, array $operatorIds, array $tagIds, int $maxScore, int $minScore, array $productIds, string $streamNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSearchHistory(["page" => $page, "pageSize" => $pageSize, "startAt" => $startAt, "endAt" => $endAt, "retoucherIds" => $retoucherIds, "operatorIds" => $operatorIds, "tagIds" => $tagIds, "maxScore" => $maxScore, "minScore" => $minScore, "productIds" => $productIds, "streamNum" => $streamNum]);
    }
    /**
     * 获取今日抽片指标
     * @return  mixed
    */
    public static function getStatistics () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStatistics();
    }
    /**
     * 云学院提交评价
     * @return  mixed
    */
    public static function commitHistory (string $spotUuid, string $uuid, int $photoId, int $scaleId, string $picUrl = '', array $tags = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->commitHistory(["spotUuid" => $spotUuid, "uuid" => $uuid, "photoId" => $photoId, "scaleId" => $scaleId, "picUrl" => $picUrl, "tags" => $tags]);
    }
    /**
     * 更新云学院修改提交评价----2.6更新
     * @return  mixed
    */
    public static function updateCommitHistory (string $uuid, int $photoId, int $scaleId, string $picUrl = '', array $tags = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCommitHistory(["uuid" => $uuid, "photoId" => $photoId, "scaleId" => $scaleId, "picUrl" => $picUrl, "tags" => $tags]);
    }
    /**
     * 获取更新云学院修改提交评价记录----2.6更新
     * @return  mixed
    */
    public static function getUpdateCommitHistoryLog (int $page, int $pageSize, string $startAt, string $endAt, string $streamNum, array $retoucherId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUpdateCommitHistoryLog(["page" => $page, "pageSize" => $pageSize, "startAt" => $startAt, "endAt" => $endAt, "streamNum" => $streamNum, "retoucherId" => $retoucherId]);
    }
    /**
     * 抽片池配置修改-test
     * @return  mixed
    */
    public static function fixCheckPoolConfig (array $configData) {
        return RpcClass::getClass(self::$serviceName, self::$className)->fixCheckPoolConfig(["configData" => $configData]);
    }
    /**
     * 添加云学院类别 ---v2.24
     * @return  int
    */
    public static function addScoreType (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addScoreType(["name" => $name]);
    }
    /**
     * 修改云学院类别 ---v2.24
     * @return  bool
    */
    public static function editScoreType (int $id, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editScoreType(["id" => $id, "name" => $name]);
    }
    /**
     * 获取云学院评分配置列表 ---v2.24
     * @return  mixed
    */
    public static function getScoreConfigList (bool $withTrashed = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getScoreConfigList(["withTrashed" => $withTrashed]);
    }
    /**
     * 添加云学院评分配置---v2.24
     * @return  mixed
    */
    public static function addScoreConfig (string $name, array $children, int $scoreTypeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addScoreConfig(["name" => $name, "children" => $children, "scoreTypeId" => $scoreTypeId]);
    }
    /**
     * 修改云学院评分配置---v2.24
     * @return  mixed
    */
    public static function editScoreConfig (int $id, string $name, array $children) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editScoreConfig(["id" => $id, "name" => $name, "children" => $children]);
    }
    /**
     * 删除云学院评分配置---v2.24
     * @return  mixed
    */
    public static function delScoreConfig (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delScoreConfig(["id" => $id]);
    }
    /**
     * 获取云学院修图师分数统计(柱状图)
     * @return  array
    */
    public static function getCloudScoreByStaffIds (string $startAt, string $endAt, array $staffIds, array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudScoreByStaffIds(["startAt" => $startAt, "endAt" => $endAt, "staffIds" => $staffIds, "productIds" => $productIds]);
    }
    /**
     * 获取云学院修图组分数统计(柱状图) ---2.24更新
     * @return  mixed
    */
    public static function getCloudScoreByGroup (string $startAt, string $endAt, array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudScoreByGroup(["startAt" => $startAt, "endAt" => $endAt, "productIds" => $productIds]);
    }
    /**
     * 获取云学院修图组分数统计(柱状图) ---2.24更新
     * @return  mixed
    */
    public static function getCloudProblemByGroup (string $startAt, string $endAt, int $scoreTypeId = 0, array $tagIds = [], array $productIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudProblemByGroup(["startAt" => $startAt, "endAt" => $endAt, "scoreTypeId" => $scoreTypeId, "tagIds" => $tagIds, "productIds" => $productIds]);
    }
    /**
     * 清空云学院记录 ---2.8更新
     * @return  mixed
    */
    public static function emptyCheckPoolByStaffId (array $staffIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->emptyCheckPoolByStaffId(["staffIds" => $staffIds]);
    }
    /**
     * 获取评分人列表 ---2.8更新
     * @return  mixed
    */
    public static function getTakeStaffList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTakeStaffList();
    }
    /**
     * 获取老评分列表 ---2.8更新
     * @return  mixed
    */
    public static function getOldScoreConfigList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOldScoreConfigList();
    }
    /**
     * 云学院换一单
     * @return  array
    */
    public static function changeItem (string $spotUuid, string $uuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeItem(["spotUuid" => $spotUuid, "uuid" => $uuid]);
    }
    /**
     * 云学院-跳过伙伴
     * @return  bool
    */
    public static function skipStaff (string $uuid, string $spotUuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->skipStaff(["uuid" => $uuid, "spotUuid" => $spotUuid]);
    }
    /**
     * 云学院检查换一单
     * @return  bool
    */
    public static function hasChangeItem (string $spotUuid, string $uuid) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hasChangeItem(["spotUuid" => $spotUuid, "uuid" => $uuid]);
    }
    /**
     * 设置评分档位
     * @return  mixed
    */
    public static function setScoreScale (\Mainto\Bridge\Structs\ProjectCloud\Objects\CheckPool\ScoreScales $scoreScales) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setScoreScale($scoreScales);
    }
    /**
     * 获取评分档位
     * @return  mixed
    */
    public static function getScoreScale () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getScoreScale();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}