<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-15 10:32:49
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Config
 */
class Config {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Config";

    /**
     * 获取沙漏列表[产品沙漏]
     * @return  mixed
    */
    public static function getHourGlassList (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHourGlassList(["page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取基础沙漏列表
     * @return  mixed
    */
    public static function getBaseHourGlassSetting (int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBaseHourGlassSetting(["page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取沙漏详情
     * @return  mixed
    */
    public static function getHourGlassInfo (int $configId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getHourGlassInfo(["configId" => $configId]);
    }
    /**
     * 开启全局沙漏状态
     * @return  mixed
    */
    public static function enableHourGlassGlobalState () {
        return RpcClass::getClass(self::$serviceName, self::$className)->enableHourGlassGlobalState();
    }
    /**
     * 关闭全局沙漏状态
     * @return  mixed
    */
    public static function disableHourGlassGlobalState () {
        return RpcClass::getClass(self::$serviceName, self::$className)->disableHourGlassGlobalState();
    }
    /**
     * 添加沙漏
     * @return  mixed
    */
    public static function addHourGlass (string $retouchStandard, array $productIds, array $staffRanges, int $baseTime, int $superimposedTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addHourGlass(["retouchStandard" => $retouchStandard, "productIds" => $productIds, "staffRanges" => $staffRanges, "baseTime" => $baseTime, "superimposedTime" => $superimposedTime]);
    }
    /**
     * 编辑沙漏
     * @return  mixed
    */
    public static function editHourGlass (int $configId, string $retouchStandard, array $productIds, array $staffRanges, int $baseTime, int $superimposedTime) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editHourGlass(["configId" => $configId, "retouchStandard" => $retouchStandard, "productIds" => $productIds, "staffRanges" => $staffRanges, "baseTime" => $baseTime, "superimposedTime" => $superimposedTime]);
    }
    /**
     * 删除沙漏
     * @return  mixed
    */
    public static function deleteHourGlass (int $configId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteHourGlass(["configId" => $configId]);
    }
    /**
     * 添加伙伴卡片配置
     * @return  mixed
    */
    public static function addCard (string $type, float $multiple, array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addCard(["type" => $type, "multiple" => $multiple, "staffIds" => $staffIds]);
    }
    /**
     * 关闭卡片配置
     * @return  mixed
    */
    public static function closeCard (int $staffCardId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeCard(["staffCardId" => $staffCardId]);
    }
    /**
     * 删除卡片配置
     * @return  mixed
    */
    public static function deleteCard (int $staffCardId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteCard(["staffCardId" => $staffCardId]);
    }
    /**
     * 获取已配置卡片列表
     * @return  mixed
    */
    public static function getStaffCardList (int $page, int $pageSize = 10, string $type, string $state, array $staffIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffCardList(["page" => $page, "pageSize" => $pageSize, "type" => $type, "state" => $state, "staffIds" => $staffIds]);
    }
    /**
     * 获取已配置冲量奖励列表
     * @return  mixed
    */
    public static function getImpulseList (int $page = 1, int $pageSize = 20, string $state, array $staffIds, array $retoucherOrgIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getImpulseList(["page" => $page, "pageSize" => $pageSize, "state" => $state, "staffIds" => $staffIds, "retoucherOrgIds" => $retoucherOrgIds]);
    }
    /**
     * 新增冲量奖励
     * @return  mixed
    */
    public static function addImpulse (string $title, array $staffIds, array $retoucherOrgIds, array $settingItemIds, string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addImpulse(["title" => $title, "staffIds" => $staffIds, "retoucherOrgIds" => $retoucherOrgIds, "settingItemIds" => $settingItemIds, "startAt" => $startAt, "endAt" => $endAt]);
    }
    /**
     * 新增冲量奖励配置
     * @return  mixed
    */
    public static function addImpulseSettingItem (float $reachExp, string $type, float $reward) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addImpulseSettingItem(["reachExp" => $reachExp, "type" => $type, "reward" => $reward]);
    }
    /**
     * 删除冲量奖励配置
     * @return  mixed
    */
    public static function delImpulseSettingItem (int $itemId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delImpulseSettingItem(["itemId" => $itemId]);
    }
    /**
     * 获取冲量奖励配置项列表
     * @return  mixed
    */
    public static function getImpulseSettingItemList (string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getImpulseSettingItemList(["type" => $type]);
    }
    /**
     * 获取冲量奖励详情
     * @return  mixed
    */
    public static function getImpulseInfo (int $impulseId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getImpulseInfo(["impulseId" => $impulseId]);
    }
    /**
     * 删除冲量奖励
     * @return  mixed
    */
    public static function deleteImpulse (int $impulseId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteImpulse(["impulseId" => $impulseId]);
    }
    /**
     * 关闭冲量奖励
     * @return  mixed
    */
    public static function disableImpulse (int $impulseId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->disableImpulse(["impulseId" => $impulseId]);
    }
    /**
     * 获取绿色通道人员
     * @return  mixed
    */
    public static function getGreenChannelInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGreenChannelInfo();
    }
    /**
     * 更新绿色通道人员
     * @return  mixed
    */
    public static function saveGreenChannelInfo (array $staffIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveGreenChannelInfo(["staffIds" => $staffIds]);
    }
    /**
     * 获取建议工作量
     * @return  mixed
    */
    public static function getSuggestWorkload (int $retouchClassId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSuggestWorkload(["retouchClassId" => $retouchClassId]);
    }
    /**
     * 保存建议工作量
     * @return  mixed
    */
    public static function saveSuggestWorkload (int $retouchClassId, array $suggestWorkload) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveSuggestWorkload(["retouchClassId" => $retouchClassId, "suggestWorkload" => $suggestWorkload]);
    }
    /**
     * 创建时段配置
     * @return  mixed
    */
    public static function addTimeIntervalRewardConfig (string $type, string $title, array $settingItemIds, array $staffIds, string $beginAt, string $endAt, float $value) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addTimeIntervalRewardConfig(["type" => $type, "title" => $title, "settingItemIds" => $settingItemIds, "staffIds" => $staffIds, "beginAt" => $beginAt, "endAt" => $endAt, "value" => $value]);
    }
    /**
     * 获取时段配置详情
     * @return  mixed
    */
    public static function getTimeIntervalRewardConfig (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTimeIntervalRewardConfig(["id" => $id]);
    }
    /**
     * 奖励配置停止
     * @return  mixed
    */
    public static function stopTimeIntervalRewardConfig (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->stopTimeIntervalRewardConfig(["id" => $id]);
    }
    /**
     * 获取时段配置列表
     * @return  mixed
    */
    public static function getTimeIntervalRewardConfigList (int $page = 1, int $pageSize = 10, array $conds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTimeIntervalRewardConfigList(["page" => $page, "pageSize" => $pageSize, "conds" => $conds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}