<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-02 19:16:56
 */
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 */
class Staff {
    private static string $serviceName = "ProjectCloud";

    private static string $className = "Staff";

    /**
     * 获取账号列表
     * @return  mixed
    */
    public static function getStaffListByPage (string $staffName = '', int $roleId = 0, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffListByPage(["staffName" => $staffName, "roleId" => $roleId, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取伙伴信息
     * @return  mixed
    */
    public static function getStaffInfo (int $staffNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffInfo(["staffNum" => $staffNum]);
    }
    /**
     * 查询伙伴信息
     * @return  mixed
    */
    public static function searchStaffInfo (int $staffNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchStaffInfo(["staffNum" => $staffNum]);
    }
    /**
     * 查询伙伴权限信息
     * @return  mixed
    */
    public static function getStaffPermission (int $staffNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffPermission(["staffNum" => $staffNum]);
    }
    /**
     * 添加伙伴 ----2.6更新
     * @return  mixed
    */
    public static function addStaff (array $productIds, int $retoucherClass, int $roleId, array $permissionIds, int $level, float $exp, string $identity, int $staffNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addStaff(["productIds" => $productIds, "retoucherClass" => $retoucherClass, "roleId" => $roleId, "permissionIds" => $permissionIds, "level" => $level, "exp" => $exp, "identity" => $identity, "staffNum" => $staffNum]);
    }
    /**
     * 编辑伙伴 ----2.6更新
     * @return  mixed
    */
    public static function editStaff (int $staffNum, array $productIds, int $retoucherClass, int $roleId, int $level, float $exp, string $identity, array $permissionIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStaff(["staffNum" => $staffNum, "productIds" => $productIds, "retoucherClass" => $retoucherClass, "roleId" => $roleId, "level" => $level, "exp" => $exp, "identity" => $identity, "permissionIds" => $permissionIds]);
    }
    /**
     * 启用伙伴
     * @return  mixed
    */
    public static function enableStaff (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enableStaff(["staffId" => $staffId]);
    }
    /**
     * 禁用伙伴
     * @return  mixed
    */
    public static function disableStaff (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->disableStaff(["staffId" => $staffId]);
    }
    /**
     * 添加修片师类别
     * @return  mixed
    */
    public static function addRetoucherClass (string $name, array $productIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addRetoucherClass(["name" => $name, "productIds" => $productIds]);
    }
    /**
     * 编辑修片师类别
     * @return  mixed
    */
    public static function editRetoucherClass (string $name, array $productIds, int $retoucherClassId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editRetoucherClass(["name" => $name, "productIds" => $productIds, "retoucherClassId" => $retoucherClassId]);
    }
    /**
     * 删除修片师类别
     * @return  mixed
    */
    public static function delRetoucherClass (int $retoucherClassId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delRetoucherClass(["retoucherClassId" => $retoucherClassId]);
    }
    /**
     * 获取等级列表
     * @return  mixed
    */
    public static function getLevelList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLevelList();
    }
    /**
     * 获取各等级升级经验值
     * @return  mixed
    */
    public static function getAllLevelExp () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllLevelExp();
    }
    /**
     * 获取修图身份列表
     * @return  array
    */
    public static function getIdentityList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getIdentityList();
    }
    /**
     * 获取修片师类别
     * @return  mixed
    */
    public static function getRetoucherClassInfo (int $retoucherClassId, bool $additionInfo = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetoucherClassInfo(["retoucherClassId" => $retoucherClassId, "additionInfo" => $additionInfo]);
    }
    /**
     * 获取修片师类别列表
     * @return  mixed
    */
    public static function getRetoucherClassList (int $retouchClassId = 0, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetoucherClassList(["retouchClassId" => $retouchClassId, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 添加角色
     * @return  mixed
    */
    public static function addRole (string $title, array $permissionIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addRole(["title" => $title, "permissionIds" => $permissionIds]);
    }
    /**
     * 编辑角色权限
     * @return  mixed
    */
    public static function editRole (int $roleId, array $permissionIds, string $title, string $desc) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editRole(["roleId" => $roleId, "permissionIds" => $permissionIds, "title" => $title, "desc" => $desc]);
    }
    /**
     * 删除角色
     * @return  mixed
    */
    public static function delRole (int $roleId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delRole(["roleId" => $roleId]);
    }
    /**
     * 获取角色信息
     * @return  mixed
    */
    public static function getRoleInfo (int $roleId, bool $additionInfo = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRoleInfo(["roleId" => $roleId, "additionInfo" => $additionInfo]);
    }
    /**
     * 获取角色列表
     * @return  mixed
    */
    public static function getRoleList (string $title, int $page = 1, int $pageSize = 10) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRoleList(["title" => $title, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取所有权限列表
     * @return  mixed
    */
    public static function getPermissionList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPermissionList();
    }
    /**
     * 获取可打分伙伴s
     * @return  mixed
    */
    public static function getCanScoreStaffs (string $type, int $groupId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCanScoreStaffs(["type" => $type, "groupId" => $groupId]);
    }
    /**
     * 批量保存staff打分信息
     * @return  bool
    */
    public static function batchSaveStaffScores (int $groupId, array $staffScores, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchSaveStaffScores(["groupId" => $groupId, "staffScores" => $staffScores, "type" => $type]);
    }
    /**
     * 编辑staff分数
     * @return  mixed
    */
    public static function editStaffScore (int $groupId, int $id, float $score) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editStaffScore(["groupId" => $groupId, "id" => $id, "score" => $score]);
    }
    /**
     * 获取Staff分数列表
     * @return  mixed
    */
    public static function getStaffScores (string $type, string $cycle, int $groupId, int $page = 1, int $pageSize = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffScores(["type" => $type, "cycle" => $cycle, "groupId" => $groupId, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 个人中心组长－个人绩效－获取月度绩效排名分数数据
     * @return  mixed
    */
    public static function getGroupScoreRanks (string $type, int $page = 1, int $pageSize = 10, string $cycle, int $groupId, string $cycleFormat, string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupScoreRanks(["type" => $type, "page" => $page, "pageSize" => $pageSize, "cycle" => $cycle, "groupId" => $groupId, "cycleFormat" => $cycleFormat, "startAt" => $startAt, "endAt" => $endAt]);
    }
    /**
     * 云端绩效查询－修图组绩效查询－－－2.8
     * @return  mixed
    */
    public static function getGroupScores (string $startAt, string $endAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getGroupScores(["startAt" => $startAt, "endAt" => $endAt]);
    }
    /**
     * 用户升级情况查询 －－－ 2.12
     * @return  mixed
    */
    public static function getStaffLevelLog (string $date, int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffLevelLog(["date" => $date, "staffId" => $staffId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}